# Archivo: Clientes.py
# Ruta: src\App\Clientes.py
# Descripción: Archivo para renderizar el menu principal de clientes y la logica del mismo html (src\templates\Clientes\Menuppal.html)
# Autor: Equipo de Desarrollo IGSA
# Fecha: 2025

from flask import render_template, session
from App.Security_Module.UserAccess import check_user_access
from App.Clientes_Module.NetworkEnvironmentMenu import menu_NetworkEnvironment

def register_clientes_routes(app, mail):
    """
    Registra las rutas relacionadas con Operaciones en la aplicación Flask.
    """

    # ================== RUTA PRINCIPAL ================== (Se renderiza a si mismo src/templates/Clientes/Menuppal.html)
    @app.route("/Clientes")
    def Clientes():
        """
        Renderiza el html propio de esta logica.
        Archivo: Menuppal.html
        Ruta: src/templates/Clientes/Menuppal.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Clientes/Menuppal.html"  
        return check_user_access(UserID, ruta, Restricted_Access)
    
# Logica del menú de Clientes
    
    # ================== SUBMENÚ: SCORE ==================
    @app.route("/Clientes/NetworkEnvironment")
    def NetworkEnvironmentMenu():
        """
        Renderiza el menú del Data Master.
        Archivo: Menu.html
        Ruta: src/templates/Clientes/Score/Menu.html
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Clientes/NetworkEnvironment/Menu.html"
        
        return check_user_access(UserID, ruta,Restricted_Access)
    
    menu_NetworkEnvironment(app, mail)
