# Archivo: ScoreNetworkEnvironment.py
# Ruta: src\App\Clientes_Module\NetworkEnvironment\ScoreNetworkEnvironment.py
# Descripción: Archivo con la logica del Score de Network Environment (src\templates\Clientes\NetworkEnvironment\ScoreNetworkEnvironment.html)
# Autor: Equipo de Desarrollo IGSA
# Fecha: 2025

from datetime import datetime
from venv import logger
from flask import jsonify, render_template, request, session
from App.Security_Module.UserAccess import check_user_access

# Importar funciones SQL
from Consultas_SQL.Clientes.NetworkEnvironment.ScoreNetworkEnvironmentQL import (
    buscar_score_view
);

def function_ScoreNetworkEnvironment(app, mail):
    """
    Agrupamos todas las funciones que importamos app en la aplicación Flask.
    """

    @app.route("/Clientes/ClientesScore/BuscarScoreView", methods=['POST'])
    def buscar_score_view_endpoint():
        """
        Endpoint para buscar el score más reciente en la base de datos.
        """

        try:
            logger.info("Buscando Score mas reciente...")

            #Busca Score en la BD
            score_date = buscar_score_view()

            if score_date:
                #Score encontrado
                logger.info("Score encontrado exitosamente")
                return jsonify({
                    "success": True,
                    "data": score_date,
                    "message": "Score encontrado exitosamente"
                }), 200
            else:
                # Score no encntrado
                logger.warning("No se encontraron registros de Score")
                return jsonify({
                    "success": False,
                    "error": {
                        "message": "No se encontraron registros de score en el sistema",
                        "code": "SCORE_NOT_FOUND",
                        "alert_type": "info"
                    }
                }), 404
        except ConnectionError as e:
            logger.error(f"Error de conexión en búsqueda de score: {str(e)}")
            return jsonify({
                "success": False,
                "error": {
                    "message": "Error de conexión con la base de datos. Intente nuevamente en unos momentos.",
                    "code": "DATABASE_CONNECTION_ERROR",
                    "alert_type": "error"
                }
            }), 500
        
        except Exception as e:
            logger.error(f"Error inesperado en búsqueda de score: {str(e)}", exc_info=True)
            return jsonify({
                "success": False,
                "error": {
                    "message": "Error interno del servidor. Si el problema persiste, contacte al administrador.",
                    "code": "INTERNAL_SERVER_ERROR",
                    "alert_type": "error",
                    "timestamp": datetime.now().isoformat()
                }
            }), 500


