# Archivo: NetworkEnvironmentMenu.py
# Ruta: src\App\Clientes_Module\NetworkEnvironmentMenu.py
# Descripción: Archivo con la logica del menú de Network Environment (src\templates\Clientes\NetworkEnvironment\Menu.html)
# Autor: Equipo de Desarrollo IGSA
# Fecha: 2025

from flask import render_template, session
from App.Security_Module.UserAccess import check_user_access
from App.Clientes_Module.NetworkEnvironment import function_ScoreNetworkEnvironment

def menu_NetworkEnvironment(app, mail):
    """
    Registra las rutas relacionadas con Clientes en la aplicación Flask.
    """
    # ================== Modulo de CLIENTE_SCORE ==================
    @app.route("/Clientes/ClientesScore/ClientScore")
    @app.login_required
    def ScoreNetworkEnvironment():
        """
        Renderiza la página de catalogo de Cliente Score.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Clientes/NetworkEnvironment/ScoreNetworkEnvironment.html"

        return check_user_access(UserID, ruta,Restricted_Access)
    
    function_ScoreNetworkEnvironment(app, mail)    
    
