# Archivo: Operaciones.py
# Ruta: src\App\Operaciones.py
# Lenguaje: Python con Flask

from flask import render_template, session
from App.Security_Module.UserAccess import check_user_access
from App.Operaciones_Module.OperMenu import menu_Operaciones


def register_operaciones_routes(app, mail):
    """
    Registra las rutas relacionadas con Operaciones en la aplicación Flask.
    """
    
    # ================== RUTA PRINCIPAL ==================
    @app.route("/Operaciones")
    @app.login_required
    def Operaciones():
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Operaciones/Menuppal.html"  
        return check_user_access(UserID, ruta, Restricted_Access)
    
    # ================== SUBMENÚ: INGENIERIA ==================
    @app.route("/Operaciones/Ingenieria")
    @app.login_required
    def Ingenieria():
        """
        Renderiza el menú del Data Master.
        Archivo: Menu.html
        Ruta: src/templates/Operaciones/Ingenieria/Menu.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/Menu.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    
    menu_Operaciones(app, mail)
    




    