# Archivo: CotizCreatedIng.py
# Ruta: src\App\Operaciones_Module\Ingenieria\Cotiz\CotizCreatedIng.py
# Descripción: Módulo para crear cotizaciones del área de ingeniería
# Autor: Equipo de Desarrollo IGSA
# Fecha: 2025

from datetime import datetime
import logging
from flask import  app, jsonify, render_template, request, session
from App.Security_Module.UserAccess import check_user_access

# Importar funciones SQL específicas
from Consultas_SQL.Operaciones.Ingenieria.Cotiz.CotizCreatedIngSQL import (
    buscar_tarea_crm, buscar_oportunidad_crm,
    data_for_email,enviarCorreoCostingCreado
)

# Configurar logging
logger = logging.getLogger('cotizaciones_especiales')

def cotizcreateding_solicitud(app, mail):
    """
    Función principal que registra todas las funciones y endpoints del módulo de cotizaciones de ingeniería.
    Args:
        app: Instancia de Flask
        mail: Instancia del sistema de mail
    """ 

    print("Registering CotizCreatedIng routes...")

    _BASE_URL = "/Ingenieria/Cotiz/CotizCreatedIng"

    #/Ingenieria/Cotiz/CotizCreatedIng/get_data_for_email
    @app.route(f"{_BASE_URL}/get_data_for_email", methods=['GET'])
    @app.login_required 
    def get_data_for_email():
        task_id = request.args.get("task_id", type=int)  # 👈 obtiene el parámetro desde la URL

        if not task_id:
            return {"error": "task_id es requerido"}, 400

        dataJson = enviarCorreoCostingCreado(task_id)
        return dataJson