

# Archivo: CotizMenu.py
# Ruta: src\App\Operaciones_module\Ingenieria\Cotiz\CotizMenu.py
# Lenguaje: Python con Flask

from flask import session
from App.Security_Module.UserAccess import check_user_access
from App.Operaciones_Module.Ingenieria.Cotiz.CotizFormQueryIng import funcion_CotizFormQueryIng
from App.Operaciones_Module.Ingenieria.Cotiz.CotizCreatedIng import cotizcreateding_solicitud
from App.Operaciones_Module.Ingenieria.Cotiz.CotizEdit import register_Cotiz_Edit

def menu_Cotizing(app, mail):
    """
    Registra las rutas relacionadas con el modulo de cotizaciones y sus sub módulos.
    """

    # ================== SUBMENÚ: CREAR NUEVA COTIZACIÓN ==================
    @app.route('/Operaciones/Ingenieria/Cotiz/CotizFormQueryIng')
    def CotizFormQueryIng():
        """
        Renderiza el modulo de creación de cotizaciones.
        Archivo: CotizFormQueryIng.html
        Ruta: src/templates/Operaciones/Ingenieria/Cotiz/CotizFormQueryIng.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/Cotiz/CotizFormQueryIng.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    
    funcion_CotizFormQueryIng(app, mail)
  
    # ================== SUBMENÚ: CREAR NUEVA COTIZACIÓN ==================
    @app.route('/Operaciones/Ingenieria/Cotiz/CotizCreatedIng')
    def CotizCreatedIng():
        """
        Renderiza el modulo de creación de cotizaciones.
        Archivo: CotizCreatedIng.html
        Ruta: src/templates/Operaciones/Ingenieria/Cotiz/CotizCreatedIng.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/Cotiz/CotizCreatedIng.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    
    cotizcreateding_solicitud(app, mail)
    
    # ================== Modulo de EDITAR COTIZACION ==================
    @app.route("/Operaciones/Ingeneria/Cotiz/CotizEdit")
    @app.login_required 
    def CotizEdit():
        """
        Renderiza el modulo de herramientas para gestionar compañias.
        Archivo: CotizEdit.html
        Ruta: src/templates/Operaciones/Ingenieria/Cotiz/CotizEdit.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/Cotiz/CotizEdit.html"
        return check_user_access(UserID, ruta,Restricted_Access)    