# Archivo: CZM_GensetModel.py
# Ruta: src\App\Operaciones_Module\Ingenieria\PE\PE_DM\CZM_GensetModel.py
# Lenguaje: Python con Flask


from flask import render_template, session
from App.Security_Module.UserAccess import check_user_access

def register_PE_DM_PE(app, mail):
    """
    Registra las rutas relacionadas con el Submenu de Operaciones y sus desarrollos en la aplicación Flask.
    """
    
    # ================== Modulo de PLANTA ELECTRICA ==================
    @app.route("/Operaciones/Ingenieria/PE/PE_DM/PlantaElectrica")
    @app.login_required 
    def PlantaElectrica():
        """
        Renderiza el modulo de herramientas para gestionar compañias.
        Archivo: CZM_GensetModel.html
        Ruta: src/templates/Operaciones/Ingenieria/PE/PE_DM/CZM_GensetModel.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/PE_DM/CZM_GensetModel.html"
        return check_user_access(UserID, ruta,Restricted_Access)