# Archivo: CZM_RadiatorModel.py
# Ruta: src\App\Operaciones_Module\Ingenieria\PE\PE_DM\CZM_RadiatorModel.py
# Lenguaje: Python con Flask


from flask import render_template, session
from App.Security_Module.UserAccess import check_user_access

def register_PE_DM_RADIADOR(app, mail):
    """
    Registra las rutas relacionadas con el Submenu de Operaciones y sus desarrollos en la aplicación Flask.
    """
    
    # ================== Modulo de RADIADOR ==================
    @app.route("/Operaciones/Ingenieria/PE/PE_DM/Radiador")
    @app.login_required 
    def Radiador():
        """
        Renderiza el modulo de herramientas para gestionar compañias.
        Archivo: CZM_RadiatorModel.html
        Ruta: src/templates/Operaciones/Ingenieria/PE/PE_DM/CZM_RadiatorModel.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/PE_DM/CZM_RadiatorModel.html"
        return check_user_access(UserID, ruta,Restricted_Access)