# Archivo: Casetas.py
# Ruta: src\App\Operaciones_Module\Ingenieria\PE\PE_DM\Casetas.py
# Lenguaje: Python con Flask


from flask import render_template, session
from App.Security_Module.UserAccess import check_user_access

def register_PE_DM_CASETAS(app, mail):
    """
    Registra las rutas relacionadas con el Submenu de Operaciones y sus desarrollos en la aplicación Flask.
    """
    
    # ================== Modulo de CASETAS ==================
    @app.route("/Operaciones/Ingenieria/PE/PE_DM/Casetas")
    @app.login_required 
    def Casetas():
        """
        Renderiza el modulo de herramientas para gestionar compañias.
        Archivo: Casetas.html
        Ruta: src/templates/Operaciones/Ingenieria/PE/PE_DM/Casetas.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/PE_DM/Casetas.html"
        return check_user_access(UserID, ruta,Restricted_Access)