# Archivo: Database_registration.py
# Ruta: src\App\Operaciones_Module\Ingenieria\PE\PE_DM\Database_registration.py
# Lenguaje: Python con Flask


from flask import render_template, session
from App.Security_Module.UserAccess import check_user_access

def register_PE_DM_ALTA_BASES(app, mail):
    """
    Registra las rutas relacionadas con el Submenu de Operaciones y sus desarrollos en la aplicación Flask.
    """
    
    # ================== Modulo de ALTA DE BASES ==================
    @app.route("/Operaciones/Ingenieria/PE/PE_DM/AltaBases")
    @app.login_required 
    def AltaBases():
        """
        Renderiza el modulo de herramientas para gestionar compañias.
        Archivo: Database_registration.html
        Ruta: src/templates/Operaciones/Ingenieria/PE/PE_DM/Database_registration.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/PE_DM/Database_registration.html"
        return check_user_access(UserID, ruta,Restricted_Access)