# Archivo: Manufacturing_NoConfig.py
# Ruta: src\App\Operaciones_Module\Ingenieria\PE\PE_DM\Manufacturing_NoConfig.py
# Lenguaje: Python con Flask


from flask import render_template, session
from App.Security_Module.UserAccess import check_user_access

def register_PE_DM_MANUFACTURACION_NOCONFIG(app, mail):
    """
    Registra las rutas relacionadas con el Submenu de Operaciones y sus desarrollos en la aplicación Flask.
    """
    
    # ================== Modulo de MANUFACURACION NO CONFIGURABLE ==================
    @app.route("/Operaciones/Ingenieria/PE/PE_DM/ManufacturacionNoConfig")
    @app.login_required 
    def ManufacturacionNoConfig():
        """
        Renderiza el modulo de herramientas para gestionar compañias.
        Archivo: Manufacturing_NoConfig.html
        Ruta: src/templates/Operaciones/Ingenieria/PE/PE_DM/Manufacturing_NoConfig.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/PE_DM/Manufacturing_NoConfig.html"
        return check_user_access(UserID, ruta,Restricted_Access)