# Archivo: Switch_Box.py
# Ruta: src\App\Operaciones_Module\Ingenieria\PE\PE_DM\Switch_Box.py
# Lenguaje: Python con Flask


from flask import render_template, session
from App.Security_Module.UserAccess import check_user_access

def register_PE_DM_CAJA_INTERRUPTOR(app, mail):
    """
    Registra las rutas relacionadas con el Submenu de Operaciones y sus desarrollos en la aplicación Flask.
    """
    
    # ================== Modulo de CAJA DE INTERRUPTOR ==================
    @app.route("/Operaciones/Ingenieria/PE/PE_DM/CajaInterruptor")
    @app.login_required 
    def CajaInterruptor():
        """
        Renderiza el modulo de herramientas para gestionar compañias.
        Archivo: Switch_Box.html
        Ruta: src/templates/Operaciones/Ingenieria/PE/PE_DM/Switch_Box.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/PE_DM/Switch_Box.html"
        return check_user_access(UserID, ruta,Restricted_Access)