# Archivo: Switches.py
# Ruta: src\App\Operaciones_Module\Ingenieria\PE\PE_DM\Switches.py
# Lenguaje: Python con Flask


from flask import render_template, session
from App.Security_Module.UserAccess import check_user_access

def register_PE_DM_INTERRUPTORES(app, mail):
    """
    Registra las rutas relacionadas con el Submenu de Operaciones y sus desarrollos en la aplicación Flask.
    """
    
    # ================== Modulo de INTERRUPTORES ==================
    @app.route("/Operaciones/Ingenieria/PE/PE_DM/Interruptores")
    @app.login_required 
    def Interruptores():
        """
        Renderiza el modulo de herramientas para gestionar compañias.
        Archivo: Switches.html
        Ruta: src/templates/Operaciones/Ingenieria/PE/PE_DM/Switches.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/PE_DM/Switches.html"
        return check_user_access(UserID, ruta,Restricted_Access)