# Archivo: Universal_Board.py
# Ruta: src\App\Operaciones_Module\Ingenieria\PE\PE_DM\Universal_Board.py
# Lenguaje: Python con Flask


from flask import render_template, session
from App.Security_Module.UserAccess import check_user_access

def register_PE_DM_TABLERO_UNIVERSAL(app, mail):
    """
    Registra las rutas relacionadas con el Submenu de Operaciones y sus desarrollos en la aplicación Flask.
    """
    
    # ================== Modulo de TABLERO UNIVERSAL ==================
    @app.route("/Operaciones/Ingenieria/PE/PE_DM/TableroUniversal")
    @app.login_required 
    def TableroUniversal():
        """
        Renderiza el modulo de herramientas para gestionar compañias.
        Archivo: Universal_Board.html
        Ruta: src/templates/Operaciones/Ingenieria/PE/PE_DM/Universal_Board.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/PE_DM/Universal_Board.html"
        return check_user_access(UserID, ruta,Restricted_Access)