# Archivo: DM_PEMenu.py
# Ruta: src\App\Operaciones_Module\Ingenieria\DM\DM_PEMenu.py
# Lenguaje: Python con Flask


from flask import render_template, session
from App.Security_Module.UserAccess import check_user_access

def menu_DataMasIngPlantasElectricas(app, mail):
    """
    Registra las rutas relacionadas con el Submenu de Operaciones y sus desarrollos en la aplicación Flask.
    """
    
    # ================== Modulo de PE_DM/Motores ==================
    @app.route("/Operaciones/Ingenieria/PE/PE_DM/Motores")
    @app.login_required 
    def Motores():
        """
        Renderiza la página de Data Master de catalogo para Plantas Electricas.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/PE_DM/CZM_EngineModel.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    

    # ================== Modulo de PE_DM/Modelos de Generadores ==================
    @app.route("/Operaciones/Ingenieria/PE/PE_DM/ModeloGeneradores")
    @app.login_required 
    def ModeloGeneradores():
        """
        Renderiza la página de Data Master de catalogo para Plantas Electricas.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/PE_DM/CZM_AlternatorModel.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    

    # ================== Modulo de PE_DM/Plantas Electricas ==================
    @app.route("/Operaciones/Ingenieria/PE/PE_DM/PlantaElectrica")
    @app.login_required 
    def PlantaElectrica():
        """
        Renderiza la página de Data Master de catalogo para Plantas Electricas.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/PE_DM/CZM_GensetModel.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    

    # ================== Modulo de PE_DM/Radiador ==================
    @app.route("/Operaciones/Ingenieria/PE/PE_DM/Radiador")
    @app.login_required 
    def Radiador():
        """
        Renderiza la página de Data Master de catalogo para Plantas Electricas.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/PE_DM/CZM_RadiatorModel.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    

    # ================== Modulo de PE_DM/Tablero Universal ==================
    @app.route("/Operaciones/Ingenieria/PE/PE_DM/TableroUniversal")
    @app.login_required 
    def TableroUniversal():
        """
        Renderiza la página de Data Master de catalogo para Plantas Electricas.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/PE_DM/Universal_Board.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    

    # ================== Modulo de PE_DM/Caja Interruptor ==================
    @app.route("/Operaciones/Ingenieria/PE/PE_DM/CajaInterruptor")
    @app.login_required 
    def CajaInterruptor():
        """
        Renderiza la página de Data Master de catalogo para Plantas Electricas.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/PE_DM/Switch_Box.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    

    # ================== Modulo de PE_DM/TANQUE EXTERNO ==================
    @app.route("/Operaciones/Ingenieria/PE/PE_DM/TanqueExterno")
    @app.login_required 
    def TanqueExterno():
        """
        Renderiza la página de Data Master de catalogo para Plantas Electricas.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/PE_DM/External_Tank.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    

    # ================== Modulo de PE_DM/CASETAS ==================
    @app.route("/Operaciones/Ingenieria/PE/PE_DM/Casetas")
    @app.login_required 
    def Casetas():
        """
        Renderiza la página de Data Master de catalogo para Plantas Electricas.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/PE_DM/Casetas.html"
        return check_user_access(UserID, ruta,Restricted_Access)

    # ================== Modulo de PE_DM/MANUFACTURACION NO CONFIGURABLE ==================
    @app.route("/Operaciones/Ingenieria/PE/PE_DM/ManufacturacionNoConfig")
    @app.login_required 
    def ManufacturacionNoConfig():
        """
        Renderiza la página de Data Master de catalogo para Plantas Electricas.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/PE_DM/Manufacturing_NoConfig.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    

    # ================== Modulo de PE_DM/TRANSFERENCIA ==================
    @app.route("/Operaciones/Ingenieria/PE/PE_DM/Transferencia")
    @app.login_required 
    def Transferencia():
        """
        Renderiza la página de Data Master de catalogo para Plantas Electricas.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/PE_DM/Transfer.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    

    # ================== Modulo de PE_DM/INTERRUPTORES ==================
    @app.route("/Operaciones/Ingenieria/PE/PE_DM/Interruptores")
    @app.login_required 
    def Interruptores():
        """
        Renderiza la página de Data Master de catalogo para Plantas Electricas.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/PE_DM/Switches.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    

    # ================== Modulo de PE_DM/ALTA DE BASES ==================
    @app.route("/Operaciones/Ingenieria/PE/PE_DM/AltaBases")
    @app.login_required 
    def AltaBases():
        """
        Renderiza la página de Data Master de catalogo para Plantas Electricas.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/PE_DM/Database_registration.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    

