# Archivo: DMMenu.py
# Ruta: src\App\Operaciones_Module\Ingenieria\DMMenu.py
# Lenguaje: Python con Flask


from flask import render_template, session
from App.Security_Module.UserAccess import check_user_access

from App.Operaciones_Module.Ingenieria.DM.DM_PEMenu import menu_DataMasIngPlantasElectricas

def menu_DataMasterIngenieria(app, mail):
    """
    Registra las rutas relacionadas con el Submenu de Operaciones y sus desarrollos en la aplicación Flask.
    """
    # ================== SUBMENÚ: Menu del Data Master de ingeniería para plantas electricas==================
    @app.route("/Operaciones/Ingenieria/PE/PE_DM")
    @app.login_required
    def PE_DM():
        """
        Renderiza el menú del Data Master.
        Archivo: Menu.html
        Ruta: src\templates\Operaciones\Ingenieria\PE\PE_DM\Menu.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/PE_DM/Menu.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    
    menu_DataMasIngPlantasElectricas(app, mail)