# Archivo: OperMenu.py
# Ruta: src\App\Operaciones_Module\OperMenu.py
# Lenguaje: Python con Flask


from flask import render_template, session
from App.Security_Module.UserAccess import check_user_access
from App.Operaciones_Module.Ingenieria.DMMenu import menu_DataMasterIngenieria

from App.Operaciones_Module.Ingenieria.CotizMenu import menu_Cotizing

def menu_Operaciones(app, mail):
    """
    Registra las rutas relacionadas con el Submenu de Operaciones y sus desarrollos en la aplicación Flask.
    """
    
    # ================== SUBMENÚ: PLANTAS ELECTRICAS PE ==================
    @app.route("/Operaciones/Ingenieria/PE")
    @app.login_required
    def PE():
        """
        Renderiza el menú del Data Master.
        Archivo: Menu.html
        Ruta: src\templates\Operaciones\Ingenieria\PE\Menu.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/PE/Menu.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    
    menu_DataMasterIngenieria(app, mail)

    # ================== SUB SUBMENÚ: TAREAS DE COTIZACIONES ==================
    @app.route("/Operaciones/Ingenieria/Cotiz")
    @app.login_required
    def CotizMenu():
        """
        Renderiza el sub menú de Tareas de cotizaciones.
        Archivo: Menu.html
        Ruta: src/templates/Operaciones/Ingenieria/Cotiz/Menu.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Operaciones/Ingenieria/Cotiz/Menu.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    
    menu_Cotizing(app, mail)