# Archivo: PreRegister.py
# Ruta: src\App\PreRegister.py
# Lenguaje: Python con Flask
from datetime import datetime
from werkzeug.security import generate_password_hash
from flask_babel import _
import re
import pyodbc
import logging
from flask import Blueprint, render_template, jsonify, request, session
from flask import Flask, render_template_string
from Consultas_SQL.registration import (
    get_companies,
    get_divisions_by_company,
    get_departments_by_company_and_division,
    get_RequestType,
    insert_user_request,
    get_Correo_Solicitud_de_alta,
    get_divisions_by_id
)
from flask_babel import _

from datetime import datetime

import smtplib
import os
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
import logging
logger = logging.getLogger(__name__)

Titulo =""

# Variables globales para almacenar correos
var_correo_empleados = ""
var_correo_norteamerica = ""
var_correo_mex = ""

correos_mex = "marisol.garcia@igsa.com.mx,markjisol.garcia@igsa.com.mx"

def PreRegister_routes(app):
    class EmailService:
        def __init__(self, sender_email=None, sender_password=None):
            """
            Inicializa el servicio de correo electrónico.
            
            Args:
                sender_email (str): Correo electrónico del remitente
                sender_password (str): Contraseña del correo electrónico
            """
            self.sender_email = sender_email or os.environ.get('EMAIL_SENDER', 'elephantSyC@igsa.com.mx')
            self.sender_password = sender_password or os.environ.get('EMAIL_PASSWORD', '5lEph@n12')
            self.smtp_server = os.environ.get('SMTP_SERVER', 'smtp.office365.com')
            self.smtp_port = int(os.environ.get('SMTP_PORT', 587))
        
        def send_registration_notification(self, request_data, recipients=None):
            """
            Envía una notificación por correo electrónico sobre una nueva solicitud de alta.
            
            Args:
                request_data (dict): Datos de la solicitud
                recipients (list): Lista de correos electrónicos a los que enviar la notificación
                
            Returns:
                bool: True si el correo se envió correctamente, False en caso contrario
            """
             #Correo para recibir la notificación de una Nueva solicitud de alta de empleado
            id=1
            correos_emp = get_Correo_Solicitud_de_alta(id)
            var_correo_empleados = ", ".join([item["Correos"] for item in correos_emp])
            #Correo para recibir la notificación de una Nueva solicitud de distribuidor EUA
            id=2
            correos_EU = get_Correo_Solicitud_de_alta(id)
            var_correo_norteamerica_EU = ", ".join([item["Correos"] for item in correos_EU])
            #Correo para recibir la notificación de una Nueva solicitud de distribuidor Canadá
            id=3
            correos_CAN = get_Correo_Solicitud_de_alta(id)
            var_correo_norteamerica_CAN = ", ".join([item["Correos"] for item in correos_CAN])
            
            # Si no se proporcionan destinatarios, filtrar los que no estén vacíos
            if not recipients:
                # Filtramos solo las variables que tienen contenido
                email_list = []
                if var_correo_empleados:
                    email_list.extend(var_correo_empleados.split(','))
                if var_correo_norteamerica_EU:
                    email_list.extend(var_correo_norteamerica_EU.split(','))
                if var_correo_norteamerica_CAN:
                    email_list.extend(var_correo_norteamerica_CAN.split(','))
                if var_correo_mex:
                    email_list.extend(var_correo_mex.split(','))
                
                # Si después de filtrar no hay correos, usar una lista vacía
                recipients = [email.strip() for email in email_list if email.strip()]
        
            request_type = request_data.get('RequestTypeID', '')
            
            # Construir el asunto según el tipo de solicitud
            subject_mapping = {
                'EMPLEADO': 'Nueva solicitud de alta de empleado',
                'DISEUA': 'Nueva solicitud de distribuidor EUA',
                'DISCAN': 'Nueva solicitud de distribuidor Canadá',
                'DISMÉX': 'Nueva solicitud de distribuidor México'
            }
            
            subject = subject_mapping.get(request_type, 'Nueva solicitud de alta')
            Titulo = subject
            # Construir el cuerpo del correo en HTML
            html_body = self._build_email_body(request_data)
            
            try:
                # Verificar que haya destinatarios
                if not recipients:
                    logger.error("No hay destinatarios para enviar el correo")
                    return False
                    
                # Configurar mensaje
                message = MIMEMultipart()
                message['From'] = self.sender_email
                message['To'] = ", ".join(recipients)
                message['Subject'] = subject
                
                # Agregar cuerpo del correo
                message.attach(MIMEText(html_body, 'html'))
                
                # Conectar con el servidor SMTP
                with smtplib.SMTP(self.smtp_server, self.smtp_port) as server:
                    server.starttls()  # Activar el modo seguro
                    server.login(self.sender_email, self.sender_password)
                    server.send_message(message)
                
                logger.info(f"Correo enviado exitosamente a {', '.join(recipients)}")
                return True
                
            except Exception as e:
                logger.error(f"Error al enviar correo: {str(e)}")
                return False
        
        def _build_email_body(self, request_data):
            """
            Construye el cuerpo del correo electrónico en HTML.
            
            Args:
                request_data (dict): Datos de la solicitud
            
            Returns:
                str: Cuerpo del correo en HTML
            """
        
            request_id = request_data.get('RequestID', 'N/A')
            request_type = request_data.get('RequestTypeID', '')
            
            DivisionID = request_data.get('DivisionID', '')
            Division_ = get_divisions_by_id (DivisionID)
            if Division_ and len(Division_) > 0:
                Division = Division_[0]["Division"]
                Division = Division.strip("()").strip("''").strip('""')
                
            
            # Construir el asunto según el tipo de solicitud
            subject_mapping = {
                'EMPLEADO': 'Nueva solicitud de alta de empleado',
                'DISEUA': 'Nueva solicitud de distribuidor Norte America',
                'DISCAN': 'Nueva solicitud de distribuidor Norte America',
                'DISMÉX': 'Nueva solicitud de distribuidor México'
            }
            
            subject = subject_mapping.get(request_type, 'Nueva solicitud de alta')
            Titulo = subject
            # Tabla HTML básica con los datos
            html = f"""
            <!DOCTYPE html>
            <html>
            <head>
                <style>
                html, body {{ 
                margin: 0;
                padding: 0;
                width: 100%;
                font-family: 'Montserrat', sans-serif;
            }}
            .container {{ 
            width: 600px;  /* Ancho fijo en lugar de max-width */
            margin: 0 auto;
            padding: 20px;
            box-sizing: border-box;
            }}
            body {{ 
                display: flex;
                justify-content: center;
                align-items: center;
                flex-direction: column;
                text-align: center;
            }}
            .main-content {{
                width: 100%;
                max-width: 600px;
                margin: 0 auto;
                text-align: center;
            }}
            .title {{ 
                color: #2a5885; 
                font-size: 16px; 
                margin: 15px 0;
                font-weight: 600;
                text-align: center;
                width: 100%;
            }}
            .message {{ 
                font-size: 12px; 
                margin: 0 auto 15px auto;
                text-align: center;
                max-width: 450px;
            }}
            .data-table {{ 
                width: 100%;
                max-width: 600px;
                margin: 0 auto;
                border-collapse: collapse;
                border-spacing: 0;
                table-layout: fixed; /* Fija el ancho de la tabla */
            }}
        
                
            .data-table th {{ 
                text-align: left; 
                padding: 8px 10px; 
                font-size: 10px; 
                margin: 0;
                line-height: 1.3;
                vertical-align: top;
                width: 10%
                overflow: hidden;
                background-color: #f2f2f2; 
                font-weight: 600;
            }}
            .data-table td {{ 
                text-align: left; 
                padding: 8px 10px; 
                font-size: 10px; 
                margin: 0;
                line-height: 1.3;
                vertical-align: top;
                width: 70%;
                word-wrap: break-word; /* Permite que las palabras se corten */
                overflow-wrap: break-word; /* Para navegadores modernos */
                hyphens: auto; /* Permite guiones para palabras largas */
                word-break: break-word;
            }}
                .data-table {{ 
        width: 100%;      /* Ocupa el 100% del contenedor */
        table-layout: fixed;  /* Crucial para controlar el ancho */
        border-collapse: collapse;
    }}
            p {{
                font-size: 12px; 
                margin-bottom: 8px; 
                text-align: center;
            }}
            .data-table tr {{ height: auto; margin: 0; padding: 0; }}
            .footer {{ 
                font-size: 10px; 
                color: #777; 
                margin: 15px auto;
                text-align: center;
                width: 100%;
            }}
            .color1 {{ background-color: rgb(192, 197, 228); }}
            .color2 {{ background-color: rgb(238, 238, 241); }}
        .color3 {{ background-color: rgb(238, 238, 241); }}
        
        
            td {{ 
                font-size: 12px;  
                }}
                
            th {{ 
                font-size: 12px;  
                }}
                
                
            </style>
            </head>
            <body>
                <div class="container">
                    <h2>{Titulo} </h2>
                    <p>Se ha registrado un nuevo usuario en la plataforma de elephant.  Por favor, revise la información .</p>
                    <br>
                    <table>
                        
                    
            """
            
            # Agregar campos específicos según el tipo de solicitud
            if request_type == 'EMPLEADO':
                html += f"""
                        <tr>
                        <th style=" width: 30%;" ></th>
                            <th class="color3" style="text-align: left; width: 10%; ">Nombre</th>
                            <td class="color1" style="text-align: left; width: 30%;">{request_data.get('FirstName', '')} {request_data.get('MiddleName', '')} {request_data.get('LastName', '')} {request_data.get('SecondLastName', '')}</td>
                            <th style=" width: 30%;" ></th>
                        </tr>
                        <tr>
                        <th style=" width: 30%;" ></th>
                            <th class="color3" style="text-align: left;  width: 10%;">Correo Electrónico</th>
                            <td class="color2" style="text-align: left;  width: 30%;">{request_data.get('CorporateEmail', '')}</td>
                            <th style=" width: 30%;" ></th>
                        </tr>
                        <tr>
                            <th style=" width: 30%;" ></th>
                            <th class="color3" style="text-align: left;  width: 10%;">Teléfono</th>
                            <td class="color1" style="text-align: left;  width: 30%;">{request_data.get('ContactPhone', '')}</td>
                            <th style=" width: 30%;" ></th>
                        </tr>
                        <tr>
                            <th style=" width: 30%;" ></th>
                            <th class="color3" style="text-align: left; width: 10%;">Número de Empleado</th>
                            <td class="color2" style="text-align: left; width: 30%;">{request_data.get('EmployeeNumber', '')}</td>
                            <th style=" width: 30%;" ></th>
                        </tr>
                        <tr>
                            <th style=" width: 30%;" ></th>
                            <th class="color3" style="text-align: left; width: 10%;">Compañía</th>
                            <td class="color1" style="text-align: left; width: 30%;">{request_data.get('CompanyID', '')}</td>
                            <th style=" width: 30%;" ></th>
                        </tr>
                        <tr>
                            <th style=" width: 30%;" ></th>
                            <th class="color3" style="text-align: left; width: 10%;">División</th>
                            <td class="color2" style="text-align: left; width: 30%;">{Division}</td>
                            <th style=" width: 30%;" ></th>
                        </tr>
                        
                        <tr>
                            <th style=" width: 30%;" ></th>
                            <th class="color3" style="text-align: left; width: 10%;">Puesto</th>
                            <td class="color1" style="text-align: left; width: 30%;">{request_data.get('Position', '')}</td>
                            <th style=" width: 30%;" ></th>
                        </tr>
                        
                        
                """
            else:  # Distribuidores (DISEUA, DISCAN, DISMÉX)
                html += f"""
                        <tr>
                            <th style=" width: 30%;" ></th>
                            <th class="color3" style="text-align: left;  width: 10%;">Razón Social</th>
                            <td class="color1" style="text-align: left;  width: 30%;">{request_data.get('BusinessName', '')}</td>
                            <th style=" width: 30%;" ></th>
                        </tr>
                    
                    
                        <tr>
                            <th style=" width: 30%;" ></th>
                            <th class="color3" style="text-align: left; width: 10%;">Correo Electrónico</th>
                            <td class="color2" style="text-align: left; width: 30%;">{request_data.get('ContactEmail', '')}</td>
                            <th style=" width: 30%;" ></th>
                        </tr>
                        <tr>
                            <th style=" width: 30%;" ></th>
                            <th class="color3" style="text-align: left; width: 10%;">Teléfono</th>
                            <td class="color1" style="text-align: left; width: 30%;">{request_data.get('ContactPhone', '')}</td>
                            <th style=" width: 30%;" ></th>
                        </tr>
                    
                        
                        <tr>
                            <th style=" width: 30%;" ></th>
                            <th class="color3" style="text-align: left; width: 10%;">Estado</th>
                            <td class="color2" style="text-align: left; width: 30%;">{request_data.get('State', '')}</td>
                            <th style=" width: 30%;" ></th>
                        </tr>
                """
                
                # Para distribuidores de México, agregar RFC
                if request_type == 'DISMÉX':
                    html += f"""
                        <tr>
                        <th style=" width: 30%;" ></th>
                            <th class="color3" style="text-align: left;  width: 10%; ">RFC</th>
                            <td class="color1" style="text-align: left;  width: 30%;">{request_data.get('RFC', '')}</td>
                            <th style=" width: 30%;" ></th>
                        </tr>
                    """
                # Para distribuidores de México, agregar RFC
                if request_type == 'DISEUA':
                    html += f"""
                        <tr>
                            <th style=" width: 30%;" ></th>
                            <th class="color3" style="text-align: left; width: 10%;">Ciudad</th>
                            <td class="color1" style="text-align: left;width: 30%; ">{request_data.get('City', '')}</td>
                            <th style=" width: 30%;" ></th>
                        </tr>
                    """
                if request_type == 'DISCAN':
                    html += f"""
                        <tr>
                            <th style=" width: 30%;" ></th>
                            <th class="color3" style="text-align: left; width: 10%;">Ciudad</th>
                            <td class="color1" style="text-align: left; width: 30%;">{request_data.get('City', '')}</td>
                            <th style=" width: 30%;" ></th>
                        </tr>
                    """
            
            # Agregar comentarios comunes a todos los tipos
            html += f"""
                        <tr>
                            <th style=" width: 30%;" ></th>
                            <th class="color3" style="text-align: left; width: 10%;">Comentarios</th>
                            <td class="color2" style="text-align: left;   width: 30%;">{request_data.get('Comments', '')}</td>
                            <th style=" width: 30%;" ></th>
                        </tr>
                    </table>
                    
                    
                    
                    <div class="footer">
                        <p style ="font-size: 8px; ">Este es un correo automático. Por favor no responda a este mensaje.</p>
                    </div>
                </div>
            </body>
            </html>
            """
            
            return html
        
        
    # Configurar logging
    logging.basicConfig(level=logging.INFO)
    logger = logging.getLogger(__name__)

    

    # Ruta principal de registro
    @app.route("/registration")
    def registration():
        """
        Renderiza la página de registro principal con las compañías disponibles.
        """
        try:
            companies = get_companies()  # Obtiene las compañías desde la base de datos
            if not companies:
                return render_template("registration.html", error="No se encontraron compañías disponibles.")
            
            return render_template(
                "registration.html",
                companies=companies,  # Lista de compañías
                divisions=[],  # Divisiones vacías al cargar la página
                departments=[]  # Departamentos vacíos al cargar la página
            )
        except Exception as e:
            # Captura cualquier error inesperado
            print(f"[Error en /registration]: {e}")
            return render_template("registration.html", error="Ocurrió un error inesperado. Intenta más tarde.")


    @app.route("/get_divisions/<string:company_id>")
    def get_divisions_Preregister(company_id):
        """
        Obtiene divisiones por compañía ID y las devuelve como JSON.
        """
        try:
            divisions = get_divisions_by_company(company_id)
            if not divisions:
                return jsonify({"error": "No se encontraron divisiones para esta compañía."}), 404
            return jsonify(divisions)
        except Exception as e:
            print(f"[Error en /get_divisions]: {e}")
            return jsonify({"error": "Ocurrió un error inesperado al obtener divisiones."}), 500

    @app.route("/get_departments/<string:company_id>/<string:division_id>")
    def get_departments_Preregister(company_id, division_id):
        """
        Obtiene departamentos filtrados por compañía y división ID y los devuelve como JSON.
        """
        try:
            departments = get_departments_by_company_and_division(company_id, division_id)
            if not departments:
                return jsonify({"error": "No se encontraron departamentos para esta división."}), 404
            return jsonify(departments)
        except Exception as e:
            print(f"[Error en /get_departments]: {e}")
            return jsonify({"error": "Ocurrió un error inesperado al obtener departamentos."}), 500

    # Rutas adicionales de pre-registro
    @app.route("/registrationMX")
    def registrationMX():
        """
        Renderiza la página de registro para distribuidores en México.
        """
        try:
            return render_template("registrationDistMX.html")  # Renderiza el HTML correspondiente
        except Exception as e:
            print(f"[Error en /registrationMX]: {e}")
            return render_template("AccessDened.html", error="Ocurrió un error al cargar la página.")

    # Rutas adicionales de Solicitud de alta
    @app.route("/solicitud_de_alta")
    def solicitud_de_alta():
        """
        Renderiza la página de registro para hacer la solicitud de alta.
        """
        try:
            RequestTypes = get_RequestType()
            companies = get_companies()  # Obtiene las compañías desde la base de datos
            if not companies:
                return render_template("registration.html", error="No se encontraron compañías disponibles.")
            if not RequestTypes:
                return render_template("registration.html", error="No se encontraron datos disponibles.")
            
            return render_template(
                "solicitud_de_alta.html",
                companies=companies,  # Lista de compañías
                RequestTypes=RequestTypes,  # Lista de compañías
                divisions=[],  # Divisiones vacías al cargar la página
                departments=[]  # Departamentos vacíos al cargar la página
            )
        except Exception as e:
            # Captura cualquier error inesperado
            print(f"[Error en /solicitud_de_alta]: {e}")
            return render_template("registration.html", error="No se encontraron compañías disponibles.")


    @app.route("/registrationEXP")
    def registrationEXP():
        """
        Renderiza la página de registro para distribuidores internacionales.
        """
        try:
            return render_template("registrationDistExport.html")  # Renderiza el HTML correspondiente
        except Exception as e:
            print(f"[Error en /registrationEXP]: {e}")
            return render_template("AccessDened.html", error="Ocurrió un error al cargar la página.")


    # Crear el Blueprint
    forms = Blueprint('forms', __name__)

    def validate_email(email):
        """Validar formato de email"""
        pattern = r'^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$'
        return re.match(pattern, email) is not None

    def validate_phone(phone):
        """Validar formato de teléfono más permisivo"""
        # Eliminar espacios en blanco, guiones, paréntesis y puntos
        clean_phone = re.sub(r'[\s\-\(\)\.]', '', phone)
        
        # Verificar que solo contenga dígitos y que tenga al menos 4 dígitos (mínimo requerido)
        return clean_phone.isdigit() and len(clean_phone) >= 4

    def validate_required_fields(data, required_fields):
        """Validar campos requeridos"""
        missing_fields = []
        for field in required_fields:
            if field not in data or not str(data[field]).strip():
                missing_fields.append(field)
        return missing_fields


    
    @app.route('/submit-form', methods=['POST'])
    def submit_form():
        
        # Declarar variables globales
        global var_correo_empleados, var_correo_norteamerica, var_correo_mex
        
        # Reinicializar variables globales
        var_correo_empleados = ""
        var_correo_norteamerica = ""
        var_correo_mex = ""

        try:
            data = request.form
            
            # Obtener tipo de solicitud
            request_type = data.get('RequestType')
            #print(f"RequestType recibido: {request_type}")
            #print(f"Datos recibidos completos: {dict(data)}")

            # Asignar correos según el tipo de solicitud
            if request_type == 'EMPLEADO':
                #Correo para recibir la notificación de una Nueva solicitud de alta de empleado
                id=1
                correos_emp = get_Correo_Solicitud_de_alta(id)
                var_correo_empleados = ", ".join([item["Correos"] for item in correos_emp])
                
            elif request_type == 'DISEUA':
                #Correo para recibir la notificación de una Nueva solicitud de distribuidor EUA
                id=2
                correos_EU = get_Correo_Solicitud_de_alta(id)
                var_correo_norteamerica_EU = ", ".join([item["Correos"] for item in correos_EU])
                
            elif request_type == 'DISCAN':
                #Correo para recibir la notificación de una Nueva solicitud de distribuidor Canadá
                id=3
                correos_CAN = get_Correo_Solicitud_de_alta(id)
                var_correo_norteamerica_CAN = ", ".join([item["Correos"] for item in correos_CAN])
                
            elif request_type == 'DISMÉX':
                var_correo_mex = correos_mex

            if not request_type:
                return jsonify({
                    'success': False,
                    'message': 'Tipo de usuario no especificado'
                }), 400

            # Validar campos requeridos según el tipo de formulario
            required_fields = {
                'EMPLEADO': [
                    'EMPFirstName', 'EMPLastName', 'EMPSecondLastName',
                    'EMPCorporateEmail', 'EMPContactPhone', 'EMPEmployeeNumber',
                    'EMPCompanyID', 'EMPDivisionID', 'EMPDepartamentID',
                    'EMPPosition', 'EMPDirectSupervisor', 'EMPPermissionType'
                ],
                'DISEUA': [
                    'EU_BusinessName', 'EU_FiscalAddress', 'EU_State',
                    'EU_City', 'EU_PostalCode', 'EU_LegalRepresentative',
                    'EU_PrimaryContact', 'EU_ContactEmail', 'EU_ContactPhone'
                ],
                'DISCAN': [
                    'EU_BusinessName', 'EU_FiscalAddress', 'EU_State',
                    'EU_City', 'EU_PostalCode', 'EU_LegalRepresentative',
                    'EU_PrimaryContact', 'EU_ContactEmail', 'EU_ContactPhone'
                ],
                'DISMÉX': [
                    'MX_BusinessName', 'MX_RFC', 'MX_FiscalAddress',
                    'MX_State', 'MX_City', 'MX_PostalCode',
                    'MX_LegalRepresentative', 'MX_PrimaryContact',
                    'MX_ContactEmail', 'MX_ContactPhone'
                ]
            }

            # No validar EMPTerms como campo requerido, solo verificar si está presente
            if request_type not in required_fields:
                return jsonify({
                    'success': False,
                    'message': 'Tipo de usuario no válido'
                }), 400

            missing = validate_required_fields(data, required_fields[request_type])
            if missing:
                return jsonify({
                    'success': False,
                    'message': 'Campos requeridos faltantes: {}'.format(', '.join(missing))
                }), 400

            # Validaciones específicas según el tipo de formulario
            if request_type == 'EMPLEADO':
                # Validar email corporativo
                if not validate_email(data['EMPCorporateEmail']):
                    return jsonify({
                        'success': False,
                        'message': 'Email corporativo no válido'
                    }), 400
                
                # Validar teléfono
                if not validate_phone(data['EMPContactPhone']):
                    return jsonify({
                        'success': False,
                        'message': 'Número de teléfono no válido'
                    }), 400

            elif request_type in ['DISEUA', 'DISCAN']:
                # Validar email de contacto
                email_field = 'EU_ContactEmail'
                if not validate_email(data[email_field]):
                    return jsonify({
                        'success': False,
                        'message': 'Email de contacto no válido'
                    }), 400
                
                # Validar teléfono
                phone_field = 'EU_ContactPhone'
                if not validate_phone(data[phone_field]):
                    return jsonify({
                        'success': False,
                        'message': 'Número de teléfono no válido'
                    }), 400

            elif request_type == 'DISMÉX':
                # Validar email de contacto
                if not validate_email(data['MX_ContactEmail']):
                    return jsonify({
                        'success': False,
                        'message': 'Email de contacto no válido'
                    }), 400
                
                # Validar teléfono
                if not validate_phone(data['MX_ContactPhone']):
                    return jsonify({
                        'success': False,
                        'message': 'Número de teléfono no válido'
                    }), 400

                # Validar formato de RFC
                rfc_pattern = r'^[A-ZÑ&]{3,4}[0-9]{6}[A-V1-9][A-Z1-9][0-9A]$'
                if not re.match(rfc_pattern, data['MX_RFC']):
                    return jsonify({
                        'success': False,
                        'message': 'RFC no válido'
                    }), 400

            # Verificar que se aceptaron los términos y condiciones
            terms_field = {
                'EMPLEADO': 'EMPTerms',
                'DISEUA': 'EU_Terms',
                'DISCAN': 'EU_Terms',
                'DISMÉX': 'MX_Terms'
            }.get(request_type)
            
            if terms_field and data.get(terms_field) not in ['1', 'true', 'on', True]:
                return jsonify({
                    'success': False,
                    'message': 'Debe aceptar los términos y condiciones'
                }), 400

            # Procesar datos manualmente según el tipo de formulario
            processed_data = {
                'RequestTypeID': request_type,
                'Status': 'PENDIENTE'
            }
            
            if request_type == 'DISMÉX':
                processed_data.update({
                    'BusinessName': data.get('MX_BusinessName', ''),
                    'LegalRepresentative': data.get('MX_LegalRepresentative', ''),
                    'PrimaryContact': data.get('MX_PrimaryContact', ''),
                    'ContactEmail': data.get('MX_ContactEmail', ''),
                    'FiscalAddress': data.get('MX_FiscalAddress', ''),
                    'PostalCode': data.get('MX_PostalCode', ''),
                    'State': data.get('MX_State', ''),
                    'City': data.get('MX_City', ''),
                    'RFC': data.get('MX_RFC', ''),
                    'ContactPhone': data.get('MX_ContactPhone', ''),
                    'Comments': data.get('MX_Comments', ''),
                    'Terms': 1 if data.get('MX_Terms') in ['true', '1', 'on', True] else 0
                })
            elif request_type in ['DISEUA', 'DISCAN']:
                processed_data.update({
                    'BusinessName': data.get('EU_BusinessName', ''),
                    'LegalRepresentative': data.get('EU_LegalRepresentative', ''),
                    'PrimaryContact': data.get('EU_PrimaryContact', ''),
                    'ContactEmail': data.get('EU_ContactEmail', ''),
                    'FiscalAddress': data.get('EU_FiscalAddress', ''),
                    'PostalCode': data.get('EU_PostalCode', ''),
                    'State': data.get('EU_State', ''),
                    'City': data.get('EU_City', ''),
                    'ContactPhone': data.get('EU_ContactPhone', ''),
                    'Comments': data.get('EU_Comments', ''),
                    'Terms': 1 if data.get('EU_Terms') in ['true', '1', 'on', True] else 0
                })
            elif request_type == 'EMPLEADO':
                processed_data.update({
                    'FirstName': data.get('EMPFirstName', ''),
                    'MiddleName': data.get('EMPMiddleName', ''),
                    'LastName': data.get('EMPLastName', ''),
                    'SecondLastName': data.get('EMPSecondLastName', ''),
                    'CorporateEmail': data.get('EMPCorporateEmail', ''),
                    'ContactPhone': data.get('EMPContactPhone', ''),
                    'EmployeeNumber': data.get('EMPEmployeeNumber', ''),
                    'CompanyID': data.get('EMPCompanyID', ''),
                    'DivisionID': data.get('EMPDivisionID', ''),
                    'DepartamentID': data.get('EMPDepartamentID', ''),
                    'Position': data.get('EMPPosition', ''),
                    'DirectSupervisor': data.get('EMPDirectSupervisor', ''),
                    'PermissionType': data.get('EMPPermissionType', ''),
                    'Comments': data.get('EMPComments', ''),
                    'Terms': 1 if data.get('EMPTerms') in ['true', '1', 'on', True] else 0
                })
            
            print(f"Datos procesados: {processed_data}")
            
            # Continuar con la inserción utilizando la función actual
            success, message = insert_user_request(processed_data)
            
            if success:
                # Extraer el ID de la solicitud del mensaje (asumiendo formato "Solicitud registrada exitosamente con ID: X")
                request_id = message.split("ID: ")[-1] if "ID: " in message else None
                if request_id:
                    # Agregar el ID a los datos procesados
                    processed_data['RequestID'] = request_id
                
                # Enviar notificación por correo electrónico
                try:
                    email_service = EmailService()
                    
                    # Preparar lista de destinatarios según el tipo de solicitud
                    recipients = []
                    
                     #Correo para recibir la notificación de una Nueva solicitud de alta de empleado
                    id=1
                    correos_emp = get_Correo_Solicitud_de_alta(id)
                    var_correo_empleados = ", ".join([item["Correos"] for item in correos_emp])
                    #Correo para recibir la notificación de una Nueva solicitud de distribuidor EUA
                    id=2
                    correos_EU = get_Correo_Solicitud_de_alta(id)
                    var_correo_norteamerica_EU = ", ".join([item["Correos"] for item in correos_EU])
                    
                    #Correo para recibir la notificación de una Nueva solicitud de distribuidor Canadá
                    id=3
                    correos_CAN = get_Correo_Solicitud_de_alta(id)
                    var_correo_norteamerica_CAN = ", ".join([item["Correos"] for item in correos_CAN])
                    
                    if var_correo_empleados:
                        recipients.extend([email.strip() for email in var_correo_empleados.split(',') if email.strip()])
                    if var_correo_norteamerica_EU:
                        recipients.extend([email.strip() for email in var_correo_norteamerica_EU.split(',') if email.strip()])
                    if var_correo_norteamerica_CAN:
                        recipients.extend([email.strip() for email in var_correo_norteamerica_CAN.split(',') if email.strip()])
                    if var_correo_mex:
                        recipients.extend([email.strip() for email in var_correo_mex.split(',') if email.strip()])
                    
                    # Enviar correo con los destinatarios específicos
                    email_sent = email_service.send_registration_notification(processed_data, recipients)
                    
                    if email_sent:
                        print(f"Correo de notificación enviado para la solicitud ID: {request_id}")
                    else:
                        print(f"No se pudo enviar el correo para la solicitud ID: {request_id}")
                except Exception as email_error:
                    print(f"Error al enviar correo: {str(email_error)}")
                
                return jsonify({
                    'success': True,
                    'message': message
                })
            else:
                return jsonify({
                    'success': False,
                    'message': message
                }), 400
        
        except Exception as e:
            print(f"Error en submit_form: {str(e)}")
            import traceback
            traceback.print_exc()  # Imprimir el traceback completo para depuración
            return jsonify({
                'success': False,
                'message': 'Error al procesar el formulario: {}'.format(str(e))
            }), 500