# Archivo: SupyCtrol.py
# Ruta: src\App\SupyCtrol.py
# Lenguaje: Python con Flask

from flask import render_template, session
from App.SupyCtrol_Module.DataMasterMenu import menu_DataMaster
from App.SupyCtrol_Module.GerenteSyCMenu import menu_GerenteSyC
from App.Security_Module.UserAccess import check_user_access


def register_supyctrol_routes(app, mail):
    """
    Registra las rutas relacionadas con Supervisión y Control (SyC) en la aplicación Flask.
    """

    # ================== RUTA PRINCIPAL ==================
    @app.route("/SyC")
    @app.login_required 
    def SyC():
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/SupYCtrol/Menuppal.html"
        return check_user_access(UserID, ruta,Restricted_Access)
        
        

    # ================== SUBMENÚ: DATA MASTER ==================
    @app.route("/SyC/data_master")
    @app.login_required 
    def SyC_data_master():
        """
        Renderiza el menú del Data Master.
        Archivo: Menu.html
        Ruta: src/templates/SupYCtrol/DataMaster/Menu.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/SupYCtrol/DataMaster/Menu.html"
        return check_user_access(UserID, ruta,Restricted_Access)
        #return render_template("SupYCtrol/DataMaster/Menu.html")
        
        

    # Traemos las rutas de las herramientas de Data Master
    menu_DataMaster(app, mail) #Submenú de Data Master

    # ================== SUBMENÚ: GERENTE SyC ==================
    @app.route("/SyC/GerenteSyc")
    @app.login_required 
    def GerenteSyc():
        """
        Renderiza el menú de herramientas del Gerente de Supervisión y Control.
        Archivo: Menu.html
        Ruta: src/templates/SupYCtrol/GerenteSyc/Menu.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/SupYCtrol/GerenteSyc/Menu.html"
        return check_user_access(UserID, ruta,Restricted_Access)
        
        #return render_template("SupYCtrol/GerenteSyc/Menu.html")
        
    
    # Traemos las rutas de las herramientas de Gerente SyC
    menu_GerenteSyC(app, mail) #Submenú de Gerente SyC

