# Archivo: DMCompany.py
# Ruta: src\App\SupyCtrol_Module\DataMaster\DMCompany.py
# Lenguaje: Python con Flask

from flask import jsonify, request
from Consultas_SQL.SupYCtrol.DataMaster.DMCompanySQL import (
    get_companies
)

def register_dmcompany_routes(app):
    """
    Registra las rutas para la gestión de compañías directamente en la aplicación Flask.
    """

    @app.route("/SyC/data_master/companias/list", methods=["GET"])
    def list_companies():
        """Retorna la lista de compañías."""
        try:
            companies = get_companies()
            return jsonify(companies), 200
        except Exception as e:
            return jsonify({"error": str(e)}), 500