# Archivo: DMDepartament.py
# Ruta: src\App\SupyCtrol_Module\DataMaster\DMDepartament.py
# Lenguaje: Python con Flask

from flask import jsonify, request
from Consultas_SQL.SupYCtrol.DataMaster.DMDepartamentSQL import (
    get_departament
)

def register_dmdepartament_routes(app):
    """
    Registra las rutas para la gestión de departamentos directamente en la aplicación Flask.
    """

    @app.route("/SyC/data_master/departament/list", methods=["GET"])
    def list_departament():
        """Retorna la lista de departamentos."""
        try:
            departament = get_departament()
            return jsonify(departament), 200
        except Exception as e:
            return jsonify({"error": str(e)}), 500