# Archivo: DMDivision.py
# Ruta: src\App\SupyCtrol_Module\DataMaster\DMDivision.py
# Lenguaje: Python con Flask

from flask import jsonify, request
from Consultas_SQL.SupYCtrol.DataMaster.DMDivisionSQL import (
    get_division
)

def register_dmdivision_routes(app):
    """
    Registra las rutas para la gestión de divisiones directamente en la aplicación Flask.
    """

    @app.route("/SyC/data_master/division/list", methods=["GET"])
    def list_division():
        """Retorna la lista de las divisiones."""
        try:
            division = get_division()
            return jsonify(division), 200
        except Exception as e:
            return jsonify({"error": str(e)}), 500