# Archivo: DataMasterMenu.py
# Ruta: src\App\SupyCtrol_Module\DataMasterMenu.py
# Lenguaje: Python con Flask

from flask import render_template, Blueprint, request,session
from App.SupyCtrol_Module.DataMaster.DMCompany import register_dmcompany_routes
from App.SupyCtrol_Module.DataMaster.DMDivision import register_dmdivision_routes
from App.SupyCtrol_Module.DataMaster.DMDepartament import register_dmdepartament_routes
from App.SupyCtrol_Module.DataMaster.DMAccessEmployee import funcion_AccessEmployees
#from Consultas_SQL.Security.save_token import (get_ModuleID,get_RoleID,get_permiso)

from App.Security_Module.UserAccess import check_user_access

def menu_DataMaster(app, mail):
    """
    Registra las rutas relacionadas con el Submenu del Data master y sus desarrollos en la aplicación Flask.
    """
    # ================== Modulo de Gestion de Compañias ==================
    @app.route("/SyC/data_master/companias")
    def gestionar_companias():
        """
        Renderiza el modulo de herramientas para gestionar compañias.
        <!-- Archivo: DMCompany.html -->
        <!-- Ruta: src/templates/SupYCtrol/DataMaster/DMCompany.html -->
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/SupYCtrol/DataMaster/DMCompany.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    
    # Agregamos el codigo de desarrollado para la gestion de compañias
    register_dmcompany_routes(app) #Modulo de Gestion de Compañias
    
    @app.route("/SyC/data_master/divisiones")
    @app.login_required 
    def gestionar_divisiones():
        """
        Renderiza el modulo de herramientas para gestionar compañias.
        <!-- Archivo: DMDivision.html -->
        <!-- Ruta: src/templates/SupYCtrol/DataMaster/DMDivision.html -->
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/SupYCtrol/DataMaster/DMDivision.html"
        return check_user_access(UserID, ruta,Restricted_Access)

        #return render_template("SupYCtrol/DataMaster/DMDivision.html")
        
    register_dmdivision_routes(app) #Modulo de Gestion de Divisiones
    
    @app.route("/SyC/data_master/despartamentos")
    @app.login_required 
    def gestionar_departamentos():
        """
        Renderiza el modulo de herramientas para gestionar compañias.
        <!-- Archivo: DMDepartament.html -->
        <!-- Ruta: src/templates/SupYCtrol/DataMaster/DMDepartament.html -->
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/SupYCtrol/DataMaster/DMDepartament.html"
        return check_user_access(UserID, ruta,Restricted_Access)
        
        #return render_template("SupYCtrol/DataMaster/DMDepartament.html")
        
    register_dmdepartament_routes(app) #Modulo de Gestion de Departamentos

    # ================== Modulo de Gestion de Permisos ==================
    @app.route("/SyC/data_master/permisos")
    def gestionar_permisos():
        """
        Renderiza la página de gestión de permisos.
        """
        return "Página en desarrollo - Gestión de Permisos"
    

    # ================== Modulo de Gestion de Roles ==================
    @app.route("/SyC/data_master/roles")
    def gestionar_roles():
        """
        Renderiza la página de gestión de roles.
        """
        return "Página en desarrollo - Gestión de Roles"

    # ================== Modulo de Gestion de Módulos ==================
    @app.route("/SyC/data_master/modulos")
    def gestionar_modulos():
        """
        Renderiza la página de gestión de módulos.
        """
        return "Página en desarrollo - Gestión de Módulos"

    # ================== Modulo de Registro de Empleados ==================
    '''
    @app.route("/SyC/data_master/empleados")
    def registrar_empleados():
        """
        Renderiza la página para el registro de empleados.
        """
        return "Página en desarrollo - Registro de Empleados"
    '''
    
    @app.route("/SyC/data_master/access_empleados")
    def access_empleados():
        """
        Renderiza la página de Acceso a Distribuidores.
        """ 
        #Restricted_Access = False
        #UserID = session.get('user_id')
        #ruta = "/SupYCtrol/DataMaster/DMAccessEmployee.html"
        #return check_user_access(UserID, ruta,Restricted_Access)
        
        return render_template("SupYCtrol/DataMaster/DMAccessEmployee.html")

    funcion_AccessEmployees(app, mail)   

