# Archivo: GSYCRutasScore.py
# Ruta: src\App\SupyCtrol_Module\GerenteSyC\GSYCRutasScore.py
# Lenguaje: Python con Flask

# Importaciones estándar
import os
import tempfile
import ftplib

# Importaciones de terceros
import requests
from dotenv import load_dotenv
from flask import jsonify, render_template, request
from werkzeug.utils import secure_filename

# Importaciones locales
from Consultas_SQL.SupYCtrol.GerenteSyC.GSYCScoreSQL import get_Consulta

# Cargar las variables de entorno desde el archivo .env
load_dotenv()

def GSYC_Score_routes(app):
    """
    Registra las rutas para la gestión directamente en la aplicación Flask.
    """

    @app.route("/SYS/GSYC/listTable2", methods=["GET"])
    def listTable2():
        """Retorna la lista de departamentos."""
        try:
            resultado = get_Consulta()
            #resultado = []
            return jsonify(resultado), 200
        except Exception as e:
            return jsonify({"error": str(e)}), 500
        