# Archivo: GSYCUtilityMaterialsMenu.py
# Ruta: src\App\SupyCtrol_Module\GerenteSyC\GSYCUtilityMaterialsMenu.py
# Lenguaje: Python con Flask
# Importaciones estándar

from flask import render_template, request, session
from App.Security_Module.UserAccess import check_user_access

from App.SupyCtrol_Module.GerenteSyC.UtilityMaterials.GSYCGetBomGenset import funciones_GetBomGenset
from App.SupyCtrol_Module.GerenteSyC.UtilityMaterials.GSYCManufacBOMIng import funciones_BomPartIng

def menu_UtilityMaterials(app, mail):
    """
    Registra las rutas relacionadas con el Submenu del Data master y sus desarrollos en la aplicación Flask.
    """
    
    # ================== Utilidades de Materiales ==================
    @app.route("/SyC/GerenteSyc/UtilityMaterials/BOM_GensetProcess")
    def GSYC_BOM_Genset_Process():
        """
        Renderiza la página BOM de Plantas en proceso.
        """
        
        UserID = session.get('user_id')
        ruta = "/SupYCtrol/GerenteSyc/UtilityMaterials/GSYCGetBomGenset.html"
        Restricted_Access = False
        return check_user_access(UserID, ruta, Restricted_Access)

    funciones_GetBomGenset(app) #Modulo de BOM de Genset en proceso
    
    
    @app.route("/SyC/GerenteSyc/UtilityMaterials/GSYCManufacBOMIng")
    def GSYC_BOM_Manufacturing_ing():
        """
        Renderiza la página BOM de Plantas estandar
        """
        
        UserID = session.get('user_id')
        ruta = "/SupYCtrol/GerenteSyc/UtilityMaterials/GSYCManufacBOMIng.html"
        Restricted_Access = False
        return check_user_access(UserID, ruta, Restricted_Access)

    funciones_BomPartIng(app) #Modulo de BOM de productos de manufactura, cargado por ingeniería
    # ==============================================================