# Archivo: GerenteSyCMenu.py
# Ruta: src\App\SupyCtrol_Module\GerenteSyCMenu.py
# Lenguaje: Python con Flask
# Importaciones estándar
import os
import tempfile
import ftplib

# Importaciones de terceros
import requests
from dotenv import load_dotenv
from flask import jsonify, render_template, request, session
from werkzeug.utils import secure_filename

# Importaciones locales
from App.Security_Module.UserAccess import check_user_access
from App.SupyCtrol_Module.GerenteSyC.GSYCRutasScore import GSYC_Score_routes

from App.SupyCtrol_Module.GerenteSyC.GSYCRutasPronFlujo_Contratos import GSYC_routes
from App.SupyCtrol_Module.GerenteSyC.GSYCRutasReporte_financiero_Contratos import GSYC_Reporte_financiero_Contratos_routes
from App.SupyCtrol_Module.GerenteSyC.GSYCRutasReporte_financiero_OV import GSYC_Reporte_financiero_OV_routes
from App.SupyCtrol_Module.GerenteSyC.GSYCUtilityMaterialsMenu import menu_UtilityMaterials

# Cargar las variables de entorno desde el archivo .env
load_dotenv()

def menu_GerenteSyC(app, mail):
    """
    Registra las rutas relacionadas con Supervisión y Control (SyC) en la aplicación Flask.
    """

   
     # ================== Modulo Score ==================
    @app.route("/SyC/GerenteSyc/DataMaster/Score")
    def Score():
        """
        Renderiza la página del Score.
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/SupYCtrol/GerenteSyc/Score.html"
        return check_user_access(UserID, ruta,Restricted_Access)
        #return render_template("/SupYCtrol/GerenteSyc/Score.html")
    # Se importo el paquete register_dmdepartament_routes
    GSYC_Score_routes(app)    
    
    # ================== Modulo Reporte_financiero_Contratos==================
    @app.route("/SyC/GerenteSyc/Reporte_financiero_Contratos")
    def Reporte_financiero_Contratos():
        """
        Renderiza la página del Reporte_financiero_Contratos.
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/SupYCtrol/GerenteSyc/GSyCReporte_financiero_Contratos.html"
        return check_user_access(UserID, ruta,Restricted_Access)
        
        #return render_template("/SupYCtrol/GerenteSyc/GSyCReporte_financiero_Contratos.html")
        
    # Se importo el paquete register_dmdepartament_routes
    GSYC_Reporte_financiero_Contratos_routes(app)        

    # ================== Modulo Reporte financiero OV ==================
    @app.route("/SyC/GerenteSyc/Reporte_financiero_OV")
    def Reporte_financiero_OV():
        """
        Renderiza la página del Reporte_financiero_OV.
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/SupYCtrol/GerenteSyc/GSyCReporte_financiero_OV.html"
        return check_user_access(UserID, ruta,Restricted_Access)
        
        #return render_template("/SupYCtrol/GerenteSyc/GSyCReporte_financiero_OV.html")
        
    # Se importo el paquete register_dmdepartament_routes
    GSYC_Reporte_financiero_OV_routes(app)    
    
    # ================== Modulo PronFlujo_Contratos ==================
    @app.route("/SyC/GerenteSyc/PronFlujo_Contratos")
    def PronFlujo_Contratos():
        """
        Renderiza la página de Catálogo de Breakers.
        """
        
        UserID = session.get('user_id')
        ruta = "/SupYCtrol/GerenteSyc/Flujo_Contratos.html"
        Restricted_Access = False
        return check_user_access(UserID, ruta, Restricted_Access)
        #return render_template("/SupYCtrol/GerenteSyc/Flujo_Contratos.html")

    # Se importo el paquete register_dmdepartament_routes
    GSYC_routes(app)



    # ================== Utilidades de Materiales ==================
    @app.route("/SyC/GerenteSyc/UtilityMatMenu")
    def GSYC_utility_for_materials_Menu():
        """
        Renderiza la página del menu de Utilidades.
        """
        
        UserID = session.get('user_id')
        ruta = "/SupYCtrol/GerenteSyc/UtilityMaterials/Menu.html"
        Restricted_Access = False
        return check_user_access(UserID, ruta, Restricted_Access)
        #return render_template("/SupYCtrol/GerenteSyc/Flujo_Contratos.html")

    # Se importo el paquete register_dmdepartament_routes
    menu_UtilityMaterials(app, mail)


    # Ejemplo de rutas desde el submenú de Supervisión y Control
    @app.route("/SyC/GerenteSyc/InfoEmpl")
    def informe_de_empleados():
        
        return "Página en desarrollo - Informe de Empleados"
    
    
    

