# Archivo: Traduccion.py
# Ruta: src\App\Traduccion.py
# Lenguaje: Python con Flask

from flask_babelplus import Babel, gettext as _
from flask import request  # Importar aquí para evitar posibles errores al usar 'request'

def init_babel(app):
    babel = Babel(app)

    @babel.localeselector
    def get_locale():
        lang = app.config.get('BABEL_DEFAULT_LOCALE', 'es')
        # Selección basada en la cookie
        return request.cookies.get('lang') or lang

    return babel
