# Archivo: test_crm_connection.py
# Ruta: src\App\Utilities_module\test_crm_connection.py
# Descripción: Módulo de prueba para verificar la conexión con el CRM
# Autor: Equipo de Desarrollo IGSA
# Fecha: 2025

import os
import json # 🆕 Necesario para imprimir el JSON bonito
from config import config
from .CRMManagement import CRMManager 

def run_test():
    
    # 🆕 Define aquí el número de oportunidad que deseas probar
    OPPORTUNITY_TO_TEST = "OP000001" 
    
    print(f"🚀 Iniciando prueba de conexión y contexto para Oportunidad: {OPPORTUNITY_TO_TEST}...")

    try:
        current_env = os.getenv("FLASK_ENV", "development")
        current_config = config[current_env]
        crm = CRMManager(config=current_config)

        # Solo llama a _get_company_guid para asegurar token y GUID
        crm._get_company_guid()
        
        # ==========================================================
        # 🆕 PRUEBA DE FUNCIÓN UNIFICADA
        # ==========================================================
        print("\n--- OBTENIENDO CONTEXTO UNIFICADO DEL CRM ---")

        # Llama a la nueva función y pasa la variable de prueba
        context = crm.get_opportunity_context(OPPORTUNITY_TO_TEST)
        
        print("\n✅ CONTEXTO CONSOLIDADO (JSON DE SALIDA):")
        # Imprime el resultado final con formato JSON para mejor lectura
        print(json.dumps(context, indent=4, ensure_ascii=False))

    except Exception as e:
        print(f"\n🚫 ERROR DURANTE LA PRUEBA: {e}")
        
if __name__ == '__main__':
    run_test()