# Archivo: Ventas.py
# Ruta: src\App\Ventas.py
# Lenguaje: Python con Flask

from flask import render_template, session

from App.Ventas_Module.VentasMenu import menu_Ventas_EUA
from App.Ventas_Module.CotizMenu import menu_Cotiz

from App.Security_Module.UserPassword import user_has_access
from App.Security_Module.UserAccess import check_user_access

from App.Ventas_Module.VentasDistMenu import menu_VentasDistribuidores
from App.Ventas_Module.VentasMatrizMenu import menu_VentasPlantasMatriz_MX

def register_ventas_routes(app, mail):
    """
    Registra las rutas relacionadas con Ventas) en la aplicación Flask.
    """
    
    # ================== RUTA PRINCIPAL ==================
    @app.route("/Ventas")
    @app.login_required
    def Ventas():
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Ventas/Menuppal.html"
        return check_user_access(UserID, ruta, Restricted_Access)
 
    # ================== SUBMENÚ: Cotizaciones ==================
    @app.route("/Ventas/Cotiz")
    @app.login_required
    def Cotiz():
        """
        Renderiza el menú de Cotizaciones.
        Archivo: Menu.html
        Ruta: src/templates/Ventas/Cotiz/Menu.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Ventas/Cotiz/Menu.html"
        
        return check_user_access(UserID, ruta,Restricted_Access)
        
    menu_Cotiz(app, mail)  # Submenú de Cotizaciones
    
    # ================== SUBMENÚ: Ventas Estados Unidos ==================
    @app.route("/Ventas/Ventas_EUA")
    @app.login_required
    def Ventas_EUA():
        """
        Renderiza el menú del Data Master.
        Archivo: Menu.html
        Ruta: src/templates/Ventas/VentasEUA/Menu.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/Menu.html"
        return check_user_access(UserID, ruta,Restricted_Access)
        
        #return render_template("Ventas/VentasEUA/Menu.html")
    
    menu_Ventas_EUA(app, mail) #Submenú de Ventas

    
    # ================== SUBMENÚ: Ventas Distribuidores México ==================    
    @app.route("/Ventas/ScoreDistributorsMX/Ventas_Distribuidores")
    @app.login_required
    def Ventas_Distribuidores():

        """
        Renderiza el formulario de cotizaciones de plantas eléctricas nacionales.
        Archivo: Menu.html
        Ruta: src/templates/Ventas/VentasDist/Menu.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasDist/Menu.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    
    menu_VentasDistribuidores(app, mail)

       
    # ================== SUBMENÚ: Ventas Plantas Matriz México ==================
    @app.route("/Ventas/ScorePlantasMatrizMX/ScorePlantasMatrizMX")
    @app.login_required
    def ScorePlantasMatrizMX():

        """
        Renderiza el formulario de cotizaciones de plantas eléctricas nacionales.
        Archivo: Menu.html
        Ruta: src/templates/Ventas/VentasMatriz/Menu.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasMatriz/Menu.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    
    menu_VentasPlantasMatriz_MX(app, mail)







    @app.route("/Ventas/Cotiz/CotizUlSolicitud/FormPEul")
    @app.login_required
    def FormPEul():

        return render_template("/Ventas/Cotiz/CotizUlSolicitud/FormPEul.html")
    
    # =================== SUBMENÚ: FORM PE MEX ====================
    @app.route("/Ventas/Cotiz/CotizEspSolicitud/FormPEmx")
    @app.login_required
    def FormPEmx():
        """
        Renderiza el formulario de cotizaciones de plantas eléctricas nacionales.
        Archivo: FormPEmx.html
        Ruta: src/templates/Ventas/Cotiz/CotizEspSolicitud/FormPEmx.html
        """
        return render_template("Ventas/Cotiz/CotizEspSolicitud/FormPEmx.html")
            

    

            
    
    

