# Archivo: CotizMenu.py
# Ruta: src\App\Ventas_Module\Cotiz\CotizMenu.py
# Lenguaje: Python con Flask

from flask import render_template, request, session

from App.Ventas_Module.Cotiz.CotizEspSolicitud import cotiz_esp_solicitud
from App.Security_Module.UserAccess import check_user_access
from App.Ventas_Module.Cotiz.RecepcionCotiz import registrar_rutas_recepcion_cotizacion

def menu_Cotiz(app, mail):
    """
    Registra las rutas relacionadas con el Submenu de Cotizaciones Comerciales y sus desarrollos en la aplicación Flask.
    """
    
    # ================== Solicitud de Cotizacion Especial ==================
    @app.route("/Ventas/Cotiz/CotizEspSolicitud")
    def CotizEspSolicitud():
        """
        Renderiza la página BOM de Plantas en proceso.
        """

        UserID = session.get('user_id')
        ruta = "/Ventas/Cotiz/CotizEspSolicitud.html"
        Restricted_Access = False
        return check_user_access(UserID, ruta, Restricted_Access)
    
    cotiz_esp_solicitud(app,mail)


    # ================== RECEPCION DE COTIZACION ==================
    @app.route("/Ventas/Cotiz/RecepcionCotiz")
    @app.login_required 
    def RecepcionCotiz():
        """
        Renderiza la pagina recepcion de cotizacion.
        Archivo: RecepcionCotiz.html
        Ruta: src/templates/Ventas/Cotiz/RecepcionCotiz.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Ventas/Cotiz/RecepcionCotiz.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    
    registrar_rutas_recepcion_cotizacion(app,mail)

