# Archivo: VentasDistMenu.py
# Ruta: src\App\Ventas_Module\VentasDistMenu.py
# Lenguaje: Python con Flask

from flask import render_template, request, session
from App.Security_Module.UserAccess import check_user_access
from App.Ventas_Module.VentasDist.ScoreDistMX import function_ScoreDistributorsM

def menu_VentasDistribuidores(app, mail):
    """
    Registra las rutas relacionadas con el Submenu de Ventas Distribuidres y sus desarrollos en la aplicación Flask.
    """
    
    # ================== Modulo de Ventas Distribuidores México ==================
    @app.route("/Ventas/ScoreDistributorsMX/VentasDistributors_MX")
    @app.login_required 
    def VentasDistributors_MX():
        """
        Renderiza el modulo de herramientas para gestionar compañias.
        Archivo: ScoreDistributorsMexico.html
        Ruta: src/templates/Ventas/VentasDist/ScoreDistributorsMexico.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "Ventas/VentasDist/ScoreDistributorsMexico.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    
    function_ScoreDistributorsM(app, mail)

    

