# Archivo: VentasMenu.py
# Ruta: src\App\Ventas_Module\VentasEUA\DMmenu.py
# Lenguaje: Python con Flask

from flask import render_template, session
from App.Ventas_Module.VentasEUA.DataMaster.DMbreakers import register_dmbreakers_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMBreakerProtectionType import register_dmBreakerProtectionType_routes
#from App.Ventas_Module.VentasEUA.DataMaster.DMBreakerProtectionTypeOptimizado import register_dmBreakerProtectionTypeOptimizado_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMControllerCatalog import register_dmCatalogo_de_controles_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMControllerPreheater import register_dmControlador_del_precalentador_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMEnclosureLight import register_dmCatalogo_de_iluminacion_de_casetas_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMControllerBattCharger import register_dmCatalogo_de_cargadores_de_baterias_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMEnclosureSpaceHeater import register_dmCatalogo_de_calentadores_de_espacio_para_casetas_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMAddAccesory_Estop import register_dmCatalogo_de_botones_de_paro_de_emergencia_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMAddAccesory_Spring import register_dmCatalogo_de_amortiguadores_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMPrjWarWarranty import register_dmCatalogo_de_garantias_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMControllerOptions import register_dmController_Options_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMEnclosureOption import register_dmEnclosure_Option_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMAddAccesory_Option import register_dmAddAccesory_Option_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMTankOptions import register_dmTank_Options_routes

from App.Ventas_Module.VentasEUA.DataMaster.DMTankSpillCont import register_dmCatalogo_de_contencion_de_derrames_de_tanques_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMEnclosureLoadCenter import register_dmCatalogo_de_centros_de_carga_para_casetas_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMbreakersOptions import register_dmbreakers_Options_routes
from App.Security_Module.UserAccess import check_user_access

from App.Ventas_Module.VentasEUA.DataMaster.Genset import register_PlantaElectrica
from App.Ventas_Module.VentasEUA.DataMaster.Enclosure import register_Caseta
from App.Ventas_Module.VentasEUA.DataMaster.Tank import register_Tanque
from App.Ventas_Module.VentasEUA.DataMaster.Test import register_Test

def menu_DataMaster_EUA(app):
    """
    Registra las rutas relacionadas con el Submenu del Data Master y sus desarrollos en la aplicación Flask.
    """
    # ================== Modulo de Genset ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Genset_EUA")
    def Genset_EUA():
        """
        Renderiza la página de Catálogo de Planta Electrica.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/Genset.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    
    register_PlantaElectrica(app)
        #"""
        #Renderiza la página de Catálogo de Genset.
        #"""
        #return render_template("Ventas/VentasEUA/VEUcotizador.html")    
        #return "Página en desarrollo - Genset_EUA guardar actualizar consultar "
    
    # ================== Modulo de Catalogo de Breakers ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Breakers_EUA")
    @app.login_required 
    def Breakers_EUA():
        """
        Renderiza la página de Catálogo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMEbreakers.html"
        return check_user_access(UserID, ruta,Restricted_Access)
        
        #return render_template("/Ventas/VentasEUA/DataMaster/DMEbreakers.html")
    
    # Se importo el paquete register_dmdepartament_routes
    register_dmbreakers_routes(app)
    
    # ================== Modulo de Data master de catalogo de Breakers options ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Breakers_Option_EUA")
    @app.login_required 
    def Breakers_Option_EUA():
        """
        Renderiza la página de Data Master de catalogo de Breakers options.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMEbreakersOptions.html"
        return check_user_access(UserID, ruta,Restricted_Access)
        
        #return render_template("/Ventas/VentasEUA/DataMaster/DMEbreakersOptions.html")
    
    register_dmbreakers_Options_routes(app)
    
     # ================== Modulo de Catalogo de Tipo de Breakers ==================
    #@app.route("/Ventas/Ventas_EUA/DataMaster/BreakerProtectionTypeOptimizado")
    @app.route("/Ventas/Ventas_EUA/DataMaster/BreakerProtectionType")
    @app.login_required 
    def BreakerProtectionType():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')      
        ruta = "/Ventas/VentasEUA/DataMaster/DMBreakerProtectionType.html"
        #ruta = "/Ventas/VentasEUA/DataMaster/DMBreakerProtectionTypeOptimizado.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    #register_dmBreakerProtectionTypeOptimizado_routes(app)
    register_dmBreakerProtectionType_routes(app)
    
       # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Catalogo_de_controles")
    @app.login_required 
    def Catalogo_de_controles():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMControllerCatalog.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    register_dmCatalogo_de_controles_routes(app)
    
        # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Controlador_del_precalentador")
    @app.login_required 
    def Controlador_del_precalentador():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMControllerPreheater.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    register_dmControlador_del_precalentador_routes(app)
    
    
        # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Catalogo_de_cargadores_de_baterias")
    @app.login_required 
    def Catalogo_de_cargadores_de_baterias():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMControllerBattCharger.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    register_dmCatalogo_de_cargadores_de_baterias_routes(app)
    
    
        # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Catalogo_de_iluminacion_de_casetas")
    @app.login_required 
    def Catalogo_de_iluminacion_de_casetas():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMEnclosureLight.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    register_dmCatalogo_de_iluminacion_de_casetas_routes(app)
    
    
    
        # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Catalogo_de_calentadores_de_espacio_para_casetas")
    @app.login_required 
    def Catalogo_de_calentadores_de_espacio_para_casetas():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMEnclosureSpaceHeater.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    register_dmCatalogo_de_calentadores_de_espacio_para_casetas_routes(app)
    
    
    
        # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Catalogo_de_centros_de_carga_para_casetas")
    @app.login_required 
    def Catalogo_de_centros_de_carga_para_casetas():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMEnclosureLoadCenter.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    register_dmCatalogo_de_centros_de_carga_para_casetas_routes(app)
    
     
        # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Catalogo_de_botones_de_paro_de_emergencia")
    @app.login_required 
    def Catalogo_de_botones_de_paro_de_emergencia():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMAddAccesory_Estop.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    register_dmCatalogo_de_botones_de_paro_de_emergencia_routes(app)
    
    
    
        # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Catalogo_de_amortiguadores")
    @app.login_required 
    def Catalogo_de_amortiguadores():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMAddAccesory_Spring.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    register_dmCatalogo_de_amortiguadores_routes(app)
    
    
        # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Catalogo_de_contencion_de_derrames_de_tanques")
    @app.login_required 
    def Catalogo_de_contencion_de_derrames_de_tanques():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMTankSpillCont.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    register_dmCatalogo_de_contencion_de_derrames_de_tanques_routes(app)
    
    
            # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Catalogo_de_garantias")
    @app.login_required 
    def Catalogo_de_garantias():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMPrjWarWarranty.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    register_dmCatalogo_de_garantias_routes(app)
    
                # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Controller_Options")
    @app.login_required 
    def Controller_Options():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMControllerOptions.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    register_dmController_Options_routes(app)
    
    # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Enclosure_Option")
    @app.login_required 
    def Enclosure_Option():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMEnclosureOption.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    register_dmEnclosure_Option_routes(app)
    
     # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/AddAccesory_Option")
    @app.login_required 
    def AddAccesory_Option():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMAddAccesory_Option.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    register_dmAddAccesory_Option_routes(app)
    
    
     # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/TankOptions")
    @app.login_required 
    def TankOptions():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMTankOptions.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    register_dmTank_Options_routes(app)


    # ================== Modulo de Planta Electrica ==================
    #@app.route("/Ventas/Ventas_EUA/DataMaster/PlantasElectricas")
    #@app.login_required 
    #def PlantasElectricas():
        

    # ================== Modulo de Caseta ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Caseta")
    @app.login_required 
    def Caseta():
        """
        Renderiza la página de Catálogo de Caseta.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/Enclosure.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    
    register_Caseta(app)

    # ================== Modulo de Tanque ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Tanque")
    @app.login_required 
    def Tanque():
        """
        Renderiza la página de Catálogo de Tanque.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/Tank.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    
    register_Tanque(app)

    # ================== Modulo de Test ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Test")
    @app.login_required 
    def Test():
        """
        Renderiza la página de Catálogo de Tanque.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/Test.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    
    register_Test(app)
    