# Archivo: VentasMenu.py
# Ruta: src\App\Ventas_Module\VentasEUA\DMmenu.py
# Lenguaje: Python con Flask

from flask import render_template, session
from App.Ventas_Module.VentasEUA.DataMaster.DMbreakers_catalog import register_dmbreakers_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMBreakerProtectionType_catalog import register_dmBreakerProtectionType_routes

from App.Ventas_Module.VentasEUA.DataMaster.DMControllerCatalog_catalog import register_dmCatalogo_de_controles_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMControllerPreheater_catalog import register_dmControlador_del_precalentador_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMEnclosureLight_catalog import register_dmCatalogo_de_iluminacion_de_casetas_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMControllerBattCharger_catalog import register_dmCatalogo_de_cargadores_de_baterias_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMEnclosureSpaceHeater_catalog import register_dmCatalogo_de_calentadores_de_espacio_para_casetas_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMAddAccesory_Estop_catalog import register_dmCatalogo_de_botones_de_paro_de_emergencia_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMAddAccesory_Spring_catalog import register_dmCatalogo_de_amortiguadores_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMPrjWarWarranty_catalog import register_dmCatalogo_de_garantias_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMControllerOptions_catalog import register_dmController_Options_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMEnclosureOption_catalog import register_dmEnclosure_Option_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMAddAccesory_Option_catalog import register_dmAddAccesory_Option_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMTankOptions_catalog import register_dmTank_Options_routes

from App.Ventas_Module.VentasEUA.DataMaster.DMTankSpillCont_catalog import register_dmCatalogo_de_contencion_de_derrames_de_tanques_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMEnclosureLoadCenter_catalog import register_dmCatalogo_de_centros_de_carga_para_casetas_routes
from App.Ventas_Module.VentasEUA.DataMaster.DMbreakersOptions_catalog import register_dmbreakers_Options_routes
from App.Security_Module.UserAccess import check_user_access
def menu_DataMaster_EUA_catalogo(app):
    """
    Registra las rutas relacionadas con el Submenu del Data Master y sus desarrollos en la aplicación Flask.
    """
    # ================== Modulo de Genset ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Genset_EUA_catalog")
    def Genset_EUA_catalog():
        """
        Renderiza la página de Catálogo de Genset.
        """
        #return render_template("Ventas/VentasEUA/VEUcotizador_catalog.html")    
        return "Página en desarrollo - Genset_EUA_catalog guardar actualizar consultar "
    
    # ================== Modulo de Catalogo de Breakers ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Breakers_EUA_catalog")
    @app.login_required 
    def Breakers_EUA_catalog():
        """
        Renderiza la página de Catálogo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMEbreakers_catalog.html"
        #return check_user_access(UserID, ruta,Restricted_Access)
        
        return render_template("/Ventas/VentasEUA/DataMaster/DMEbreakers_catalog.html")
    
    # Se importo el paquete register_dmdepartament_routes
    register_dmbreakers_routes(app)
    
    # ================== Modulo de Data master de catalogo de Breakers options ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Breakers_Option_EUA_catalog")
    @app.login_required 
    def Breakers_Option_EUA_catalog():
        """
        Renderiza la página de Data Master de catalogo de Breakers options.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMEbreakersOptions_catalog.html"
        #return check_user_access(UserID, ruta,Restricted_Access)
        
        return render_template("/Ventas/VentasEUA/DataMaster/DMEbreakersOptions_catalog.html")
    
    register_dmbreakers_Options_routes(app)
    
     # ================== Modulo de Catalogo de Tipo de Breakers ==================
    #@app.route("/Ventas/Ventas_EUA/DataMaster/BreakerProtectionTypeOptimizado")
    @app.route("/Ventas/Ventas_EUA/DataMaster/BreakerProtectionType_catalog")
    @app.login_required 
    def BreakerProtectionType_catalog():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')      
        ruta = "/Ventas/VentasEUA/DataMaster/DMBreakerProtectionType_catalog_catalog.html"
        return render_template("/Ventas/VentasEUA/DataMaster/DMBreakerProtectionType_catalog.html")
        #ruta = "/Ventas/VentasEUA/DataMaster/DMBreakerProtectionType_catalogOptimizado_catalog.html"
        #return check_user_access(UserID, ruta,Restricted_Access)
    #register_DMBreakerProtectionType_catalogOptimizado_routes(app)
    register_dmBreakerProtectionType_routes(app)
    
       # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Catalogo_de_controles_catalog")
    @app.login_required 
    def Catalogo_de_controles_catalog():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMControllerCatalog_catalog_catalog.html"
        #return check_user_access(UserID, ruta,Restricted_Access)
        return render_template("/Ventas/VentasEUA/DataMaster/DMControllerCatalog_catalog.html")
    register_dmCatalogo_de_controles_routes(app)
    
        # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Controlador_del_precalentador_catalog")
    @app.login_required 
    def Controlador_del_precalentador_catalog():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMControllerPreheater_catalog_catalog.html"
        #return check_user_access(UserID, ruta,Restricted_Access)
        return render_template("/Ventas/VentasEUA/DataMaster/DMControllerPreheater_catalog.html")
    register_dmControlador_del_precalentador_routes(app)
    
    
        # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Catalogo_de_cargadores_de_baterias_catalog")
    @app.login_required 
    def Catalogo_de_cargadores_de_baterias_catalog():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMControllerBattCharger_catalog.html"
        #return check_user_access(UserID, ruta,Restricted_Access)
        return render_template("/Ventas/VentasEUA/DataMaster/DMControllerBattCharger_catalog.html")
    register_dmCatalogo_de_cargadores_de_baterias_routes(app)
    
    
        # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Catalogo_de_iluminacion_de_casetas_catalog")
    @app.login_required 
    def Catalogo_de_iluminacion_de_casetas_catalog():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMEnclosureLight_catalog_catalog.html"
        #return check_user_access(UserID, ruta,Restricted_Access)
        return render_template("/Ventas/VentasEUA/DataMaster/DMEnclosureLight_catalog.html")
    register_dmCatalogo_de_iluminacion_de_casetas_routes(app)
    
    
    
        # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Catalogo_de_calentadores_de_espacio_para_casetas_catalog")
    @app.login_required 
    def Catalogo_de_calentadores_de_espacio_para_casetas_catalog():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMEnclosureSpaceHeater_catalog_catalog.html"
        #return check_user_access(UserID, ruta,Restricted_Access)
        return render_template("/Ventas/VentasEUA/DataMaster/DMEnclosureSpaceHeater_catalog.html")
    register_dmCatalogo_de_calentadores_de_espacio_para_casetas_routes(app)
    
    
    
        # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Catalogo_de_centros_de_carga_para_casetas_catalog")
    @app.login_required 
    def Catalogo_de_centros_de_carga_para_casetas_catalog():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMEnclosureLoadCenter_catalog_catalog.html"
        #return check_user_access(UserID, ruta,Restricted_Access)
        return render_template("/Ventas/VentasEUA/DataMaster/DMEnclosureLoadCenter_catalog.html")
    register_dmCatalogo_de_centros_de_carga_para_casetas_routes(app)
    
     
        # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Catalogo_de_botones_de_paro_de_emergencia_catalog")
    @app.login_required 
    def Catalogo_de_botones_de_paro_de_emergencia_catalog():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMAddAccesory_Estop_catalog_catalog.html"
        #return check_user_access(UserID, ruta,Restricted_Access)
        return render_template("/Ventas/VentasEUA/DataMaster/DMAddAccesory_Estop_catalog.html")
    register_dmCatalogo_de_botones_de_paro_de_emergencia_routes(app)
    
    
    
        # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Catalogo_de_amortiguadores_catalog")
    @app.login_required 
    def Catalogo_de_amortiguadores_catalog():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMAddAccesory_Spring_catalog_catalog.html"
        #return check_user_access(UserID, ruta,Restricted_Access)
        return render_template("/Ventas/VentasEUA/DataMaster/DMAddAccesory_Spring_catalog.html")
    register_dmCatalogo_de_amortiguadores_routes(app)
    
    
        # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Catalogo_de_contencion_de_derrames_de_tanques_catalog")
    @app.login_required 
    def Catalogo_de_contencion_de_derrames_de_tanques_catalog():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMTankSpillCont_catalog_catalog.html"
        #return check_user_access(UserID, ruta,Restricted_Access)
        return render_template("/Ventas/VentasEUA/DataMaster/DMTankSpillCont_catalog.html")
    register_dmCatalogo_de_contencion_de_derrames_de_tanques_routes(app)
    
    
            # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Catalogo_de_garantias_catalog")
    @app.login_required 
    def Catalogo_de_garantias_catalog():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMPrjWarWarranty_catalog.html"
        return render_template("/Ventas/VentasEUA/DataMaster/DMPrjWarWarranty_catalog.html")
        #return check_user_access(UserID, ruta,Restricted_Access)
    register_dmCatalogo_de_garantias_routes(app)
    
                # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Controller_Options_catalog")
    @app.login_required 
    def Controller_Options_catalog():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMControllerOptions_catalog.html"
        return render_template("/Ventas/VentasEUA/DataMaster/DMControllerOptions_catalog.html")
        #return check_user_access(UserID, ruta,Restricted_Access)
    register_dmController_Options_routes(app)
    
    # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/Enclosure_Option_catalog")
    @app.login_required 
    def Enclosure_Option_catalog():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMEnclosureOption_catalog.html"
        #return check_user_access(UserID, ruta,Restricted_Access)
        return render_template("/Ventas/VentasEUA/DataMaster/DMEnclosureOption_catalog.html")
    register_dmEnclosure_Option_routes(app)
    
     # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/AddAccesory_Option_catalog")
    @app.login_required 
    def AddAccesory_Option_catalog():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMAddAccesory_Option_catalog_catalog.html"
        #return check_user_access(UserID, ruta,Restricted_Access)
        return render_template("/Ventas/VentasEUA/DataMaster/DMAddAccesory_Option_catalog.html")
    register_dmAddAccesory_Option_routes(app)
    
    
     # ================== Modulo de Catalogo de Controles ==================
    @app.route("/Ventas/Ventas_EUA/DataMaster/TankOptions_catalog")
    @app.login_required 
    def TankOptions_catalog():
        """
        Renderiza la página de Catálogo de Tipo de Breakers.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/DataMaster/DMTankOptions_catalog_catalog.html"
        #return check_user_access(UserID, ruta,Restricted_Access)
        return render_template("/Ventas/VentasEUA/DataMaster/DMTankOptions_catalog.html")
    register_dmTank_Options_routes(app)
    