# Optimized Python Code
# Archivo: DMControllerPreheater.py
# Ruta: src\App\Ventas_Module\VentasEUA\DataMaster\DMControllerPreheater.py
# Lenguaje: Python con Flask

from flask import Flask, render_template, send_file, abort, url_for, jsonify, request,session
import os
from dotenv import load_dotenv
import ftplib
from werkzeug.utils import secure_filename
import tempfile
from App.Security_Module.UserPassword import user_has_access
from App.Subir_Archivo import subir_archivo_ftp_desde_request,view_pdf_file,verificar_actualizar_archivos
from Consultas_SQL.Ventas.VentasEUA.DataMaster.DMControllerPreheaterSQL import (
    get_Controlador_del_precalentador, insert_Controlador_del_precalentador,update_Controlador_del_precalentador,delete_Controlador_del_precalentador,item_exists,searchitems,update_Controlador_del_precalentador_TechnicalSheet
    )
import requests
import os
# Cargar las variables de entorno desde el archivo .env
load_dotenv()
# /////////////////////////////////
#   Variables Generales
# ////////////////////////////////
ruta_pdf = "/domains/sycelephant.com/public_html/file/Ventas/EUA/DMITEMS/CONTROLLER_PREHEATER"
carpeta = "/Ventas/EUA/DMITEMS/CONTROLLER_PREHEATER/"
# /////////////////////////////////
#   Funciones Genericas
# ////////////////////////////////


# /////////////////////////////////
#   Varifica items Repetidos
# ////////////////////////////////
def existen_items(item):
    result = item_exists(item)
    if result:  # Verifica si result no es None (puede ser None si la consulta no encuentra nada)
        count = int(result[0]) # Accede al primer elemento de la tupla (índice 0) y lo convierte a entero.
    else:
        count = 0
    return count

# /////////////////////////////////
#   Funciones dedicadas
# ////////////////////////////////

def register_dmControlador_del_precalentador_routes(app):
  
    # /////////////////////////////////
    #   Consultar Breakers
    # ////////////////////////////////
    @app.route("/ventas/data_master/Controlador_del_precalentador/listControlador_del_precalentador", methods=["GET"])
    def list_Controlador_del_precalentador():
        """
        user_id = session.get('user_id')
        if not user_has_access(user_id, "Ventas","read"):
            message = "No tiene permisos para visualizar este archivo"
            return render_template("Security/AccessDened.html",message)
        """
        """Retorna la lista de get_Controlador_del_precalentador."""
        try:
            TIPOSCONTROLES = get_Controlador_del_precalentador()
            return jsonify(TIPOSCONTROLES), 200
        except Exception as e:
            return jsonify({"error": str(e)}), 500
    # Función para verificar si un item ya existe en la base de datos
    
    @app.route("/ventas/pdf_viewerControlador_del_precalentador/view/<path:filename_or_url>")
    def ver_pdfControlador_del_precalentador(filename_or_url):
        """Endpoint para visualizar un archivo PDF específico."""
        return view_pdf_file(filename_or_url)
    # /////////////////////////////////
    #   Guardar Breakers
    # ////////////////////////////////
    @app.route("/ventas/data_master/brakers/addControlador_del_precalentador", methods=["POST"])
    def add_Controlador_del_precalentador():
        user_id = session.get('user_id')
        try:
            item = request.form.get("item")
            description = request.form.get("description")
            price = request.form.get("price")
            technicalSheet = request.files.get("TechnicalSheet")
            
            if not all([item, description, price]): 
                return jsonify({"error": "Todos los campos son obligatorios."}), 400
            
            # Verificar si el item ya existe
            if existen_items(item) == 1:
                return jsonify({"error": "El item ya existe en el catálogo."}), 400
            
            filename = None
            if technicalSheet:
                resultado = subir_archivo_ftp_desde_request(technicalSheet, item, ruta_pdf,carpeta)
                if resultado["exito"]:
                    filename = resultado["url_web"]
                else:
                    return jsonify({"error": resultado["mensaje"]}), 400
            
            # Database Insert
            result = insert_Controlador_del_precalentador(item, description, price, filename)
            
            return jsonify({"message": "Catálogo de precalentadores agregado exitosamente."}), 201
        
        except Exception as e:
            return jsonify({"error": str(e)}), 500
    # /////////////////////////////////
    #   Actualizar inputs de  ControllerPreheater
    # ////////////////////////////////
    @app.route("/ventas/data_master/updateControlador_del_precalentador", methods=["POST"])
    def update_Controlador_del_precalentador_route():
        
        """Actualiza un breaker en la base de datos."""
        try:
            data = request.get_json()
            item = data.get("item")
            description = data.get("description")
            price = data.get("price")

            if not all([item, description, price]):
                return jsonify({"error": "Todos los campos son obligatorios."}), 400
            update_Controlador_del_precalentador(item, description, price)
            return jsonify({"message": "Catálogo de precalentadores actualizado exitosamente."}), 200
        except Exception as e:
            return jsonify({"error": str(e)}), 500
        
    # /////////////////////////////////
    #   Eliminar Breakers
    # ////////////////////////////////
    @app.route("/ventas/data_master/Controlador_del_precalentador/deleteControlador_del_precalentador", methods=["POST"])
    def delete_Controlador_del_precalentador_route():
        """Elimina un control de la base de datos."""
        try:
            data = request.get_json()
            item = data.get("item")
            if not item:
                return jsonify({"error": "El campo Item es obligatorio."}), 400
            delete_Controlador_del_precalentador(item)
            return jsonify({"message": "Catálogo de precalentadores eliminado exitosamente."}), 200
        except Exception as e:
            return jsonify({"error": str(e)}), 500
            
    # /////////////////////////////////
    #   Revisar la tabla CZE_ControllerPreheater y verificar si estan en archivos de fichas tecnicas  
    # ////////////////////////////////
    @app.route("/ventas/data_master/Controlador_del_precalentador/actualizarControlador_del_precalentador", methods=["GET"])
    def updated_Controlador_del_precalentador_route():
        """Actualiza todas las Fichas técnicas verificando su existencia en el servidor."""
        
        try:
            # Configuramos la ruta al módulo y el nombre de la función
            module_path = "Consultas_SQL.Ventas.VentasEUA.DataMaster.DMControllerPreheaterSQL"
            function_name = "searchitems"
            
            # Llamamos a verificar_actualizar_archivos con la configuración dinámica
            resultado = verificar_actualizar_archivos(
                tabla="CZE_ControllerPreheater",
                campo_id="Item_preheater_volt",
                campo_url="TechnicalSheet",
                update_function=update_Controlador_del_precalentador_TechnicalSheet,
                ruta_remota=ruta_pdf,
                module_path=module_path,             # Pasamos la ruta al módulo
                search_function_name=function_name,  # Pasamos el nombre de la función
                base_url="https://file.sycelephant.com",
                carpeta = carpeta
            )
            
            if resultado["exito"]:
                return jsonify({"message": resultado["mensaje"]}), 200
            else:
                print(f"Error en actualización: {resultado['mensaje']}")
                return jsonify({"error": resultado["mensaje"]}), 500
                
        except Exception as e:
            import traceback
            print(f"Error en la actualización: {str(e)}")
            print(traceback.format_exc())
            return jsonify({"error": str(e)}), 500