# Optimized Python Code
# Archivo: DMEnclosureSpaceHeater.py
# Ruta: src\App\Ventas_Module\VentasEUA\DataMaster\DMEnclosureSpaceHeater.py
# Lenguaje: Python con Flask

from flask import Flask, render_template, send_file, abort, url_for, jsonify, request,session
import os
from dotenv import load_dotenv
import ftplib
from werkzeug.utils import secure_filename
import tempfile
from App.Security_Module.UserPassword import user_has_access
from App.Subir_Archivo import subir_archivo_ftp_desde_request,view_pdf_file,verificar_actualizar_archivos
from Consultas_SQL.Ventas.VentasEUA.DataMaster.DMEnclosureSpaceHeaterSQL import (
    get_Catalogo_de_calentadores_de_espacio_para_casetas, insert_Catalogo_de_calentadores_de_espacio_para_casetas,update_Catalogo_de_calentadores_de_espacio_para_casetas,delete_Catalogo_de_calentadores_de_espacio_para_casetas,item_exists,searchitems,update_Catalogo_de_calentadores_de_espacio_para_casetas_TechnicalSheet
    )
import requests
import os
# Cargar las variables de entorno desde el archivo .env
load_dotenv()
# /////////////////////////////////
#   Variables Generales
# ////////////////////////////////
ruta_pdf = "/domains/sycelephant.com/public_html/file/Ventas/EUA/DMITEMS/ENCLOSURE_SPACE_HEATER"
carpeta = "/Ventas/EUA/DMITEMS/ENCLOSURE_SPACE_HEATER/"
# /////////////////////////////////
#   Funciones Genericas
# ////////////////////////////////


# /////////////////////////////////
#   Varifica items Repetidos
# ////////////////////////////////
def existen_items(item):
    result = item_exists(item)
    if result:  # Verifica si result no es None (puede ser None si la consulta no encuentra nada)
        count = int(result[0]) # Accede al primer elemento de la tupla (índice 0) y lo convierte a entero.
    else:
        count = 0
    return count


# /////////////////////////////////
#   Funciones dedicadas
# ////////////////////////////////

def register_dmCatalogo_de_calentadores_de_espacio_para_casetas_routes(app):
    """
    Registra las rutas para la gestión de departamentos directamente en la aplicación Flask.
    """
    # /////////////////////////////////
    #   Consultar Breakers
    # ////////////////////////////////
    @app.route("/ventas/data_master/Catalogo_de_calentadores_de_espacio_para_casetas/listCatalogo_de_calentadores_de_espacio_para_casetas", methods=["GET"])
    def list_Catalogo_de_calentadores_de_espacio_para_casetas_catalog():
        """
        user_id = session.get('user_id')
        if not user_has_access(user_id, "Ventas","read"):
            message = "No tiene permisos para visualizar este archivo"
            return render_template("Security/AccessDened.html",message)
        """
        """Retorna la lista de get_Catalogo_de_calentadores_de_espacio_para_casetas."""
        try:
            TIPOSCONTROLES = get_Catalogo_de_calentadores_de_espacio_para_casetas()
            return jsonify(TIPOSCONTROLES), 200
        except Exception as e:
            return jsonify({"error": str(e)}), 500
    # Función para verificar si un item ya existe en la base de datos
    
    @app.route("/ventas/pdf_viewerCatalogo_de_calentadores_de_espacio_para_casetas/view/<path:filename_or_url>")
    def ver_pdfCatalogo_de_calentadores_de_espacio_para_casetas_catalog(filename_or_url):
        """Endpoint para visualizar un archivo PDF específico."""
        return view_pdf_file(filename_or_url)
  