# Optimized Python Code
# Archivo: DMTankOptions.py
# Ruta: src\App\Ventas_Module\VentasEUA\DataMaster\DMTankOptions.py
# Lenguaje: Python con Flask

from flask import Flask, render_template, send_file, abort, url_for, jsonify,  request,session
import os
from dotenv import load_dotenv
import ftplib
from werkzeug.utils import secure_filename
import tempfile
from App.Subir_Archivo import subir_archivo_ftp_desde_request,view_pdf_file,verificar_actualizar_archivos
from Consultas_SQL.Ventas.VentasEUA.DataMaster.DMTankOptionsSQL import (
    get_TankOptions,update_TankOptions,item_exists,searchitems,update_TankOptions_TechnicalSheet
)
from App.Security_Module.UserPassword import user_has_access
import requests
import os
# Cargar las variables de entorno desde el archivo .env
load_dotenv()
# /////////////////////////////////
#   Variables Generales
# ////////////////////////////////
ruta_pdf = "/domains/sycelephant.com/public_html/file/Ventas/EUA/DMITEMS/TANKOPTIONS"
carpeta = "/Ventas/EUA/DMITEMS/TANKOPTIONS/"
# /////////////////////////////////
#   Funciones Genericas
# ////////////////////////////////


# /////////////////////////////////
#   Varifica items Repetidos
# ////////////////////////////////
def existen_items(item):
    result = item_exists(item)
    if result:  # Verifica si result no es None (puede ser None si la consulta no encuentra nada)
        count = int(result[0]) # Accede al primer elemento de la tupla (índice 0) y lo convierte a entero.
    else:
        count = 0
    return count

# /////////////////////////////////
#   Funciones dedicadas
# ////////////////////////////////
def register_dmTank_Options_routes(app):
    """
    Registra las rutas para la gestión de departamentos directamente en la aplicación Flask.
    """
    # /////////////////////////////////
    #   Consultar Breakers
    # ////////////////////////////////
    @app.route("/ventas/data_master/TankOptions/listTankOptions", methods=["GET"])
    def listTankOptions_catalog():
        """
        user_id = session.get('user_id')
        if not user_has_access(user_id, "Ventas", "read"):
            message = "No tiene permisos para visualizar"
            return render_template("Security/AccessDened.html",message)
        """
        """Retorna la lista de opciones de breaker."""
        try:
            departament = get_TankOptions()
            return jsonify(departament), 200
        except Exception as e:
            return jsonify({"error": str(e)}), 500
    # Función para verificar si un item ya existe en la base de datos
    
