# Optimized Python Code
# Archivo: DMBreakersOptions.py
# Ruta: src\App\Ventas_Module\VentasEUA\DataMaster\DMBreakersOptions.py
# Lenguaje: Python con Flask

from flask import Flask, render_template, send_file, abort, url_for, jsonify,  request,session
import os
from dotenv import load_dotenv
import ftplib
from werkzeug.utils import secure_filename
import tempfile
from App.Subir_Archivo import subir_archivo_ftp_desde_request,view_pdf_file,verificar_actualizar_archivos
from Consultas_SQL.Ventas.VentasEUA.DataMaster.DMbreakersOptionsSQL import (
    get_BreakersOptions,update_BreakersOptions,item_exists,searchitems,update_BreakersOptions_TechnicalSheet
)
from App.Security_Module.UserPassword import user_has_access
import requests
import os
# Cargar las variables de entorno desde el archivo .env
load_dotenv()
# /////////////////////////////////
#   Variables Generales
# ////////////////////////////////
ruta_pdf = "/domains/sycelephant.com/public_html/file/Ventas/EUA/DMITEMS/BREAKER_OPTION"
carpeta = "/Ventas/EUA/DMITEMS/BREAKER_OPTION/"
# /////////////////////////////////
#   Funciones Genericas
# ////////////////////////////////


# /////////////////////////////////
#   Varifica items Repetidos
# ////////////////////////////////
def existen_items(item):
    result = item_exists(item)
    if result:  # Verifica si result no es None (puede ser None si la consulta no encuentra nada)
        count = int(result[0]) # Accede al primer elemento de la tupla (índice 0) y lo convierte a entero.
    else:
        count = 0
    return count

# /////////////////////////////////
#   Funciones dedicadas
# ////////////////////////////////
def register_dmbreakers_Options_routes(app):
    """
    Registra las rutas para la gestión de departamentos directamente en la aplicación Flask.
    """
    # /////////////////////////////////
    #   Consultar Breakers Options
    # ////////////////////////////////
    @app.route("/ventas/data_master/BreakersOptions/listBreakersOptions", methods=["GET"])
    def listBreakersOptions():
        """
        user_id = session.get('user_id')
        if not user_has_access(user_id, "Ventas", "read"):
            message = "No tiene permisos para visualizar"
            return render_template("Security/AccessDened.html",message)
        """
        """Retorna la lista de opciones de breaker."""
        try:
            departament = get_BreakersOptions()
            return jsonify(departament), 200
        except Exception as e:
            return jsonify({"error": str(e)}), 500
    # Función para verificar si un item ya existe en la base de datos
    

    # /////////////////////////////////
    #   Actualizar inputs de  Breakers
    # ////////////////////////////////
    @app.route("/ventas/data_master/BreakersOptions/updateBreakersOptions", methods=["POST"])
    def update_BreakersOptions_route():
        """Actualiza un breaker en la base de datos."""
        try:
            data = request.get_json()
            item = data.get("item")
            price = data.get("price")

            if not all([item, price]):
                return jsonify({"error": "Todos los campos son obligatorios."}), 400

            update_BreakersOptions(item, price)
            return jsonify({"message": "Breaker actualizado exitosamente."}), 200
        except Exception as e:
            return jsonify({"error": str(e)}), 500
        
     
    # /////////////////////////////////
    #   Revisar la tabla CZE_BreakersCatalog y verificar si estan en archivos de fichas tecnicas  
    # ////////////////////////////////
    @app.route("/ventas/data_master/BreakersOptions/actualizarBreakersOptions", methods=["GET"])
    def updated_BreakersOptions_route():
        """Actualiza todas las Fichas técnicas verificando su existencia en el servidor."""
        
        try:
            # Configuramos la ruta al módulo y el nombre de la función
            module_path = "Consultas_SQL.Ventas.VentasEUA.DataMaster.DMbreakersOptionsSQL"
            function_name = "searchitems"
            
            # Llamamos a verificar_actualizar_archivos con la configuración dinámica
            resultado = verificar_actualizar_archivos(
                tabla="CZE_BreakersOptions",
                campo_id="Item_breaker_options",
                campo_url="TechnicalSheet",
                update_function=update_BreakersOptions_TechnicalSheet,
                ruta_remota=ruta_pdf,
                module_path=module_path,             # Pasamos la ruta al módulo
                search_function_name=function_name,  # Pasamos el nombre de la función
                base_url="https://file.sycelephant.com",
                carpeta = carpeta
            )
            
            if resultado["exito"]:
                return jsonify({"message": resultado["mensaje"]}), 200
            else:
                print(f"Error en actualización: {resultado['mensaje']}")
                return jsonify({"error": resultado["mensaje"]}), 500
                
        except Exception as e:
            import traceback
            print(f"Error en la actualización: {str(e)}")
            print(traceback.format_exc())
            return jsonify({"error": str(e)}), 500