# Optimized Python Code
# Archivo: DMbreakers.py
# Ruta: src\App\Ventas_Module\VentasEUA\DataMaster\DMbreakers.py
# Lenguaje: Python con Flask

from flask import Flask, render_template, send_file, abort, url_for, jsonify, request,session
import os
from dotenv import load_dotenv
import ftplib
from werkzeug.utils import secure_filename
import tempfile
from App.Security_Module.UserPassword import user_has_access
from App.Subir_Archivo import subir_archivo_ftp_desde_request,view_pdf_file,verificar_actualizar_archivos
from Consultas_SQL.Ventas.VentasEUA.DataMaster.DMbreakersSQL import (
    get_breakers, insert_breaker,update_breaker,delete_breaker,item_exists,searchitems,update_breaker_TechnicalSheet
)
"""
from Consultas_SQL.Ventas.VentasEUA.DataMaster.DMBreakersOptimizadoSQL import (
    get_breakers, insert_breaker,update_breaker,delete_breaker,item_exists,searchitems,update_breaker_TechnicalSheet
)
"""
import requests
import os
# Cargar las variables de entorno desde el archivo .env
load_dotenv()
# /////////////////////////////////
#   Variables Generales
# ////////////////////////////////
# ruta_pdf = "/var/www/html/src/static/pdf/Ventas/EUA/DMITEMS/BREAKER_CATALOG"
ruta_pdf = "/domains/sycelephant.com/public_html/file/Ventas/EUA/DMITEMS/BREAKER_CATALOG"
carpeta = "/Ventas/EUA/DMITEMS/BREAKER_CATALOG/"
# /////////////////////////////////
#   Funciones Genericas
# ////////////////////////////////

# /////////////////////////////////
#   Varifica items Repetidos
# ////////////////////////////////
def existen_items(item):
    result = item_exists(item)
    if result:  # Verifica si result no es None (puede ser None si la consulta no encuentra nada)
        count = int(result[0]) # Accede al primer elemento de la tupla (índice 0) y lo convierte a entero.
    else:
        count = 0
    return count

# /////////////////////////////////
#   Funciones dedicadas
# ////////////////////////////////

def register_dmbreakers_routes(app):
    # /////////////////////////////////
    #   Consultar Breakers
    # ////////////////////////////////
    @app.route("/ventas/data_master/brakers/listbreakers", methods=["GET"])
    def list_breakers_catalog():
        """
        user_id = session.get('user_id')
        if not user_has_access(user_id, "Ventas","read"):
            message = "No tiene permisos para visualizar este archivo"
            return render_template("Security/AccessDened.html",message)
        """
        """Retorna la lista de departamentos."""
        try:
            departament = get_breakers()
            return jsonify(departament), 200
        except Exception as e:
            return jsonify({"error": str(e)}), 500
    # Función para verificar si un item ya existe en la base de datos
    
    @app.route("/ventas/pdf_viewer/view/<path:filename_or_url>")
    def ver_pdf_catalog(filename_or_url):
        """Endpoint para visualizar un archivo PDF específico."""
        return view_pdf_file(filename_or_url)

        #Actualiza todas las Fichas técnicas verificando su existencia en el servidor.
        
        try:
            # Configuramos la ruta al módulo y el nombre de la función
            module_path = "Consultas_SQL.Ventas.VentasEUA.DataMaster.DMbreakersSQL"  # Corregido el nombre del módulo
            function_name = "searchitems"
            
            # Llamamos a verificar_actualizar_archivos con la configuración dinámica
            resultado = verificar_actualizar_archivos(
                tabla="CZE_BreakersCatalog",
                campo_id="Item_breaker",  # Asegúrate de que esto coincida con la clave en el diccionario
                campo_url="TechnicalSheet",
                update_function=update_breaker_TechnicalSheet,
                ruta_remota=ruta_pdf,
                search_function_name=function_name,  # Pasamos el nombre de la función
                module_path=module_path,             # Pasamos la ruta al módulo
                base_url="https://file.sycelephant.com",
                carpeta = carpeta
            )
            if resultado["exito"]:
                return jsonify({"message": resultado["mensaje"]}), 200
            else:
                print(f"Error en actualización: {resultado['mensaje']}")
                return jsonify({"error": resultado["mensaje"]}), 500
                    
        except Exception as e:
            import traceback
            print(f"Error en la actualización: {str(e)}")
            print(traceback.format_exc())
            return jsonify({"error": str(e)}), 500