# Archivo: VentasMatrizMenu.py
# Ruta: src\App\Ventas_Module\VentasMatrizMenu.py
# Lenguaje: Python con Flask

from flask import render_template, session
from App.Security_Module.UserAccess import check_user_access
from App.Ventas_Module.VentasMatriz.ScoreMatrizMX import function_ScorePlantasMatriz


def menu_VentasPlantasMatriz_MX(app, mail):
    """
    Registra las rutas relacionadas con el Submenu de Operaciones y sus desarrollos en la aplicación Flask.
    """
    
    # ================== Modulo de Ventas Distribuidores México ==================
    @app.route("/Ventas/ScorePlantasMatrizMX/ScorePlantasMatriz")
    @app.login_required 
    def ScorePlantasMatriz():
        """
        Renderiza el modulo de herramientas para gestionar compañias.
        Archivo: ScorePlantasMatrizMX.html
        Ruta: src/templates/Ventas/VentasMatriz/ScorePlantasMatrizMX.html
        """
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasMatriz/ScorePlantasMatrizMX.html"
        return check_user_access(UserID, ruta,Restricted_Access)
    
    function_ScorePlantasMatriz(app, mail)