# Archivo: VentasMenu.py
# Ruta: src\App\Ventas_Module\VentasMenu.py
# Lenguaje: Python con Flask

from flask import render_template, session

from App.Ventas_Module.VentasEUA.Cotizador import get_optionsimput
from App.Ventas_Module.VentasEUA.DMmenu import menu_DataMaster_EUA
from App.Ventas_Module.VentasEUA.DMmenu_catalogos import menu_DataMaster_EUA_catalogo
from App.Ventas_Module.VentasEUA.AccessDistributors import funcion_AccessDistributors
from App.Security_Module.UserAccess import check_user_access
from Consultas_SQL.Security.UserPasswordSQL import (get_ModuleID, get_RoleID, get_permiso, get_CompanyID_DivisionID_DepartamentID_Profile)

def menu_Ventas_EUA(app, mail):
    """
    Registra las rutas relacionadas con el Submenu de Ventas y sus desarrollos en la aplicación Flask.
    """
        
    # ================== Modulo de Cotizador ==================
    @app.route("/Ventas/Ventas_EUA/Cotizador_EUA")
    @app.login_required 
    def Cotizador_EUA():
        """
        Renderiza el modulo de herramientas para gestionar compañias.
        Archivo: VEUcotizador.html
        Ruta: src/templates/Ventas/VentasEUA/VEUcotizador.html
        """
        # Validar si 
        Restricted_Access = False
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/VEUcotizador.html"
        return check_user_access(UserID, ruta,Restricted_Access)
        
        #return render_template("Ventas/VentasEUA/VEUcotizador.html")
       
    
    # Agregamos el codigo de desarrollado para el cotizador
    get_optionsimput(app,mail)
    
    # ================== Modulo de Catalogo de Productos ==================
    @app.route("/Ventas/Catalogos_EUA")
    @app.login_required 
    def Catalogos_EUA():
        """
        Renderiza la página de Catálogo de Productos.
        """
        UserID = session.get('user_id')
        
        Restricted_Access = False
        ruta = "/Ventas/VentasEUA/DataMaster/Menu_catalogos.html"
        #return check_user_access(UserID, ruta,Restricted_Access )
        return render_template("/Ventas/VentasEUA/DataMaster/Menu_catalogos.html")
    
    menu_DataMaster_EUA_catalogo(app)
    
    # ================== Modulo de Data master de catalogo de productos ==================
    @app.route("/Ventas/DataMaster_EUA")
    @app.login_required 
    def DataMaster_EUA():
        """
        Renderiza la página de Data Master de catalogo de productos.
        """
        UserID = session.get('user_id')
        
        Restricted_Access = True
        ruta = "/Ventas/VentasEUA/DataMaster/Menu.html"
        return check_user_access(UserID, ruta,Restricted_Access )
        

    menu_DataMaster_EUA(app)
    # ================== Modulo de Acceso a Distribuidores ==================
    @app.route("/Ventas/AccessDistributors")
    @app.login_required 
    def AccessDistributors():
        """
        Renderiza la página de Acceso a Distribuidores.
        """
        Restricted_Access = True
        UserID = session.get('user_id')
        ruta = "/Ventas/VentasEUA/AccessDistributors.html"
        return check_user_access(UserID, ruta,Restricted_Access)
        
        #return render_template( "Ventas/VentasEUA/AccessDistributors.html" )
    
    funcion_AccessDistributors(app, mail)  
    
    # ================== Modulo de Informes de Ventas ==================
    @app.route("/Ventas/InformesVentas_EUA")
    @app.login_required 
    def InformesVentas_EUA():
        """
        Renderiza la página de Informes de Ventas.
        """
        return "Página en desarrollo - Informes de ventas"    
    
    # ================== Modulo de Autorizacion de Cotizaciones ==================
    @app.route("/Ventas/AutorizarCotizacion_EUA")
    def AutorizarCotizacion_EUA():
        """
        Renderiza la página de Autorización de Cotizaciones.
        """
        return "Página en desarrollo - Autorización de Cotizaciones"    
    
    # ================== Modulo de Solicitud de Orden de Venta ==================
    @app.route("/Ventas/SolicitudOV_EUA")
    def SolicitudOV_EUA():
        """
        Renderiza la página de Solicitudes de Orden de Venta.
        """
        return "Página en desarrollo - Solicitud de Orden de Venta"    