# Ubicación: src/App/api/stop_button_routes.py

# Ya no necesitas importar Blueprint
from flask import Blueprint, jsonify 
from Consultas_SQL.conexion import get_connection
from ..services.StopButtonEnclosureOptions_Service import *

from Consultas_SQL.conexion import get_connection

# --- PASO 1: Define una función que recibirá la instancia de la app ---

router = Blueprint('stop_button', __name__)


service = StopButtonEnclosureOptionsService()
# Instanciamos nuestro servicio para usarlo en las rutas

@router.route("/2", methods=["GET"])
def get_all_options2():
    """
    Obtiene todos los registros de StopButtonEnclosureOptions.
    ---
    tags:
      - Stop Button Options
    responses:
      200:
        description: Una lista de todas las opciones.
      500:
        description: Error interno del servidor.
    """
    try:
        # 1. El controller llama al service
        with get_connection() as conn:
            with conn.cursor() as cursor:
                cursor.execute("SELECT * FROM StopButtonEnclosureOptions")
                columnas = [columna[0] for columna in cursor.description]
                filas = cursor.fetchall()
                return [dict(zip(columnas, fila)) for fila in filas]
    except Exception as e:
        # 3. El controller maneja los errores
        return jsonify({"error": str(e)}), 500


@router.route("/", methods=["GET"])
def get_all_options():
    """
    Obtiene todos los registros de StopButtonEnclosureOptions.
    ---
    tags:
      - Stop Button Options
    responses:
      200:
        description: Una lista de todas las opciones.
      500:
        description: Error interno del servidor.
    """
    try:
        # 1. El controller llama al service
        results = service.get_all()
        # 2. El controller formatea la respuesta
        return jsonify(results)
    except Exception as e:
        # 3. El controller maneja los errores
        return jsonify({"error": str(e)}), 500


@router.route("/<id>", methods=["GET"])
def get_option_by_id(id: str):
    """
    Retorna una opción por su ID.
    ---
    tags:
      - Stop Button Options
    parameters:
      - name: id
        in: path
        type: string
        required: true
        description: El ID de la opción a buscar.
    responses:
      200:
        description: La opción encontrada.
      404:
        description: No se encontró ninguna opción con el ID especificado.
      500:
        description: Error interno del servidor.
    """
    try:
        result = service.get_by_id(id)
        if result:
            return jsonify(result)
        else:
            # Manejo correcto del error 404
            return jsonify({"error": f"Opción con id '{id}' no encontrada."}), 404
    except Exception as e:
        return jsonify({"error": str(e)}), 500