from flask import Blueprint, request, jsonify
# Asumo que el servicio está en un módulo accesible
from ..services import quotation_Service 

router = Blueprint('quotation', __name__)


@router.route('/parts', methods=['GET'])
def get_parts_controller():
    """
    Controlador que maneja la petición GET a /api/parts/<search_term>.
    Regresa todas las partes desde ambos orígenes (Epicor y Elephant).
    """
    try:
        # 3. Pasa el término de búsqueda de la URL al método del servicio.
        parts_data = quotation_Service.Quotation_Service.getParts_From_Epicor() + quotation_Service.Quotation_Service.getPartes_From_Elephant()

    # La lógica de serialización y respuesta se mantiene igual,
        # ya que el servicio sigue devolviendo una lista de DTOs o False.
        if isinstance(parts_data, list):
            # Convierte la lista de objetos a una lista de diccionarios
            parts_as_dicts = [part.to_dict() for part in parts_data]
            return jsonify(parts_as_dicts)
        else:
            # Si el servicio devolvió False (indicando un error)
            return jsonify({"error": "No se pudieron obtener las partes"}), 500

    except Exception as e:
        # Manejo de errores inesperados en el controlador
        # Es buena idea loggear el error para depuración
        print(f"Error en el controlador get_parts_controller: {e}")
        return jsonify({"error": "Ocurrió un error interno en el servidor"}), 500
