# Archivo: quotation_cotiz_controller.py
from flask import Blueprint, jsonify
from ..services import quotation_cotiz_services

router = Blueprint('quotation_cotiz', __name__)

@router.route('/tasks/<int:task_id>', methods=['GET'])
def get_task_by_id_controller(task_id: int):
    """
    Controlador para obtener una única tarea por su TaskID.
    """
    try:
        task_data = quotation_cotiz_services.Quotation_Cotiz_Service.getQuotationTaskById(task_id)
        
        if task_data:
            # Datos recuperados para su envio
            print(f'Datos recuperados del servicio para el cliente: {task_data.to_dict()}')
            
            return jsonify(task_data.to_dict())
        else:
            # Si no se encuentra la tarea, se retorna un error 404 (Not Found)
            return jsonify({"error": f"Tarea con ID {task_id} no encontrada"}), 404
            
    except Exception as e:
        print(f"Error en get_task_by_id_controller: {e}")
        return jsonify({"error": "Ocurrió un error interno en el servidor"}), 500