# Ubicación: src/App/api/stop_button_service.py
from typing import List, Dict, Tuple, Set, Optional
from Consultas_SQL.conexion import get_connection
# Asegúrate de que la ruta de importación a tu modelo Pydantic sea la correcta
from ..schemas.StopButtonEnclosureOptions import StopButtonEnclosureOptions

class StopButtonEnclosureOptionsService:
    """
    Capa de servicio para gestionar la lógica de negocio y el acceso a datos
    para las opciones del botón de parada.

    Esta clase devuelve diccionarios listos para ser serializados a JSON.
    """
    def get_all(self) -> List[Dict]:
        """
        Obtiene todos los registros de StopButtonEnclosureOptions desde la base de datos
        y los devuelve como una lista de diccionarios.
        """
        with get_connection() as conn:
            with conn.cursor() as cursor:
                cursor.execute("SELECT * FROM StopButtonEnclosureOptions")
                columnas = [columna[0] for columna in cursor.description]
                filas = cursor.fetchall()
                
                # 1. Convierte cada fila de la DB en un diccionario
                resultados_dict = [dict(zip(columnas, fila)) for fila in filas]
                
                # 2. Valida cada diccionario creando una instancia del modelo Pydantic
                modelos = [StopButtonEnclosureOptions(**data) for data in resultados_dict]

                
                # 3. Convierte cada modelo Pydantic validado de nuevo a un diccionario
                return [modelo.model_dump() for modelo in modelos]


    def get_by_id(self, item_id: str) -> Optional[Dict]:
        """
        Obtiene un registro por su ID desde la base de datos.
        Devuelve un diccionario si lo encuentra, o None si no.
        """
        with get_connection() as conn:
            with conn.cursor() as cursor:
                cursor.execute("SELECT * FROM StopButtonEnclosureOptions WHERE stop_id = ?", (item_id,))
                columnas = [columna[0] for columna in cursor.description]
                fila = cursor.fetchone() 
                
                # Si no se encuentra la fila, devuelve None
                if not fila:
                    return None
                
                # 1. Convierte la fila en un diccionario
                datos_dict = dict(zip(columnas, fila))
                
                # 2. Valida los datos creando una instancia del modelo Pydantic
                modelo = StopButtonEnclosureOptions(**datos_dict)
                
                # 3. Convierte el modelo Pydantic validado a un diccionario para la respuesta
                return modelo.model_dump()
    
    
    def get_description(self,stop_id : str) :
        """
        Obtiene los valores de los campos especificados en getFields.

        params:
        - getFields: Lista de nombres de campos a obtener.

        return:
        - Diccionario con los valores de los campos solicitados.
        """
        try:
            with get_connection() as conn:
                with conn.cursor() as cursor:
                    query = f"SELECT stop_decription FROM StopButtonEnclosureOptions WHERE stop_id = ?;"
                    cursor.execute(query, (stop_id))
                    result = cursor.fetchone()
                    return result
        except Exception as e:
            print(f"Error obteniendo campos de CZE_Quotes: {e}")
            return None
