# Archivo: ScoreNetworkEnvironmentQL.py
# Ruta: src\Consultas_SQL\Clientes\NetworkEnvironment\ScoreNetworkEnvironmentQL.py
# Descripción: Aplicacion que gestionan la base de datos de acuerdo a la logica para el archivo ScoreNetwork.py (src\App\Clientes_Module\NetworkEnvironment\ScoreNetworkEnvironment.py)
# Autor: Equipo de Desarrollo IGSA
# Fecha: 2025

import pyodbc
import logging
from datetime import datetime
from typing import Dict, List, Optional, Union
from config import Productivo, ENVIRONMENT
from Consultas_SQL.conexion import get_connection

# Configurar logging
logger = logging.getLogger('clientes_score_sql')

def buscar_score_view() -> Optional[List[Dict]]:
    """
    Buscar los registros de score en la base de datos.
    """
    query = """
        SELECT 
            Score.[OrderNum&Line] AS ordernumandline,
            Score.OrderNum, Score.Capacidad,
            Score.Voltaje, Score.Tipo, 
            Score.Caseta, Score.JobNum2,
            Score.FechaProducción,
            Score.FechaMat, Score.AvanceDeSurtimiento,
            Score.AvisoDeTerminacion, Score.MaterialFaltante,
            Score.PartNum_M, Score.Description_M,
            Score.RefCategory_M, 
            Score.NoSerie_M, Score.Faltante_M,
            Score.En_PO_Altern_M, Score.Estatus_M,
            Score.Fecha_Llegada_M, Score.PartNum_G,
            Score.Description_G, 
            Score.NoSerie_G,
            Score.Faltante_G, Score.En_PO_Altern_G,
            Score.Estatus_G, Score.Fecha_Llegada_G
        FROM 
            Score 
        WHERE
            Score.OrderNum IN (
            '126309', '126308', '126307', '126306', '126305', '126304', '126303', '126302', '126301', '126300',
            '126299', '126298', '126297', '126296', '126295', '126294', '126293', '126292', '126291', '126290',
            '126289', '126288', '126287', '126286', '126285', '126284', '126283', '126282', '126281', '126280',
            '126279', '126278', '126277', '126276', '126275', '126274', '126273', '126272', '126271', '126270',
            '126269', '126268', '126267', '126266', '126265', '126264', '126263', '126262', '126261', '126260',
            '126259', '126258', '126257', '126256', '126255', '126254', '126253', '126252', '126251', '126250',
            '126249', '126248', '126247', '126246', '126245', '126244'
        )
        """

    conn = None

    try:
        # Obtener la conexión
        conn = get_connection()
        if not conn :
            raise ConnectionError("No se pudo establecer conexión con la base de datos")

        with conn:
            cursor = conn.cursor()
            cursor.execute(query)

            # Obtener los nombres de las columnas
            columns = [column[0] for column in cursor.description]

            #Obtener todos los resultaados
            rows = cursor.fetchall()

            if rows:
                results = []
                for row in rows:
                    result = dict(zip(columns, row))

                    # Convertir a datetume a string para JSON Serelaization
                    for date_field in ['CreatedAt', 'UpdatedAt']:
                        if date_field in result and result[date_field]:
                            result[date_field] = result[date_field].isoformat()

                    results.append(result)

                logger.info(f"Se encontraron {len(results)} registros de score")
                return results
            else:
                # Log cuando no se encuentra el score
                logger.warning("No se encontraron registros en la tabla Score")
                return None
    except pyodbc.Error as e:
        error_msg = f"Error de base de datos al buscar los scores: {str(e)}"
        logger.error(error_msg)
        raise Exception(error_msg)
    
    except ConnectionError as e:
        error_msg = f"Error de conexión al buscar los scores: {str(e)}"
        logger.error(error_msg)
        raise Exception(error_msg)
    
    except Exception as e:
        error_msg = f"Error inesperado al buscar los scores: {str(e)}"
        logger.error(error_msg)
        raise Exception(error_msg)
    
    finally:
        # Asegurar que la conexión se cierra
        if conn:
            try:
                conn.close()
            except Exception:
                logger.warning("Error al cerrar la conexión ala BD")
