# Archivo: UserPasswordSQL.py
# Ruta: src\Consultas_SQL\Security\UserPasswordSQL.py
# Lenguaje: Python con Flask

from Consultas_SQL.conexion import get_connection
from datetime import datetime, timedelta, timezone
def consultar_profile(UserID):
    try:
        check_user_query = """
            SELECT RequestTypeID, FirstName, MiddleName, LastName, SecondLastName, BusinessName, Email 
            FROM Profiles WHERE USERID = ?
        """
        with get_connection() as conn:
            cursor = conn.cursor()
            cursor.execute(check_user_query, (UserID,))
            data = cursor.fetchone()
            
            if data:
                request_type_id = data[0]  # Obtener el RequestTypeID
                Email = data[6]

                if request_type_id == 'EMPLEADO':
                    # Retornar FirstName, MiddleName, LastName, SecondLastName, Email
                    Nombre = f"{data[1]} {data[2]} {data[3]} {data[4]}"
                    # Validar data 2
                    # Checar el formulario para clientes si no esta crearlo, si esta el RFC solicitud_de_alta 
                   
                elif request_type_id in ('DISCAN', 'DISEUA', 'DISMÉX','CLIMÉX','CLIEXT'):
                    Nombre = data[5] #BusinessName
                    
                else:
                    print(f"RequestTypeID desconocido: {request_type_id}")
                    return None
                return {'Nombre': Nombre, 'Email': Email} #Retornamos las variables.
                
            else:
                print(f"No se encontró perfil para UserID: {UserID}")
                return None
            
            

    except Exception as e:
        print(f"Error: {e}")
        raise
        
        
def save_Token(UserID, Token):
    try:
        # 1. Primero, verificar si el UserID existe en la tabla Users
        check_user_query = """
            SELECT COUNT(*) FROM Users WHERE UserID = ?
        """
        
        # 2. Usamos la fecha actual + 30 minutos para ExpiresAt

        #expires_at = datetime.utcnow() + timedelta(minutes=30)
        expires_at = datetime.utcnow() + timedelta(minutes=4320)  #Se reemplaza por las 72hrs para el registro de password se realizan pruebas

        with get_connection() as conn:
            cursor = conn.cursor()
            
            # Verificar si el usuario existe
            cursor.execute(check_user_query, [UserID])
            user_count = cursor.fetchval()
            
            if not user_count:
                # El usuario no existe, devolver error
                print(f"Error: El UserID {UserID} no existe en la tabla Users")
                return None
            
            # 3. Insertar el token - CORREGIDO para SQL Server
            insert_query = """
                INSERT INTO ActivationTokens (UserID, Token, CreatedAt, ExpiresAt, IsUsed)
                OUTPUT INSERTED.ActivationTokenID
                VALUES (?, ?, GETDATE(), ?, 0);
            """
            
            values = (UserID, Token, expires_at)
            
            # Ejecutar la consulta y obtener el ID insertado directamente
            cursor.execute(insert_query, values)
            token_id = cursor.fetchone()[0]  # Obtener el primer valor de la primera fila
            
            conn.commit()
            
            return token_id
            
    except Exception as e:
        print(f"Error guardando token: {e}")
        raise
    
def get_ModuleID(ruta):
    """
    Busca el módulo correspondiente a la ruta proporcionada.
    Retorna una tupla (ModuleID, CompanyID, DivisionID, DepartamentID)
    o lanza LookupError si no se encuentra.
    """
    import logging
    logger = logging.getLogger('user_access')

    try:
        if not ruta:
            raise ValueError("Ruta vacía o nula proporcionada a get_ModuleID().")

        # 🔹 Mantener la ruta tal cual, solo limpiando espacios
        ruta_limpia = ruta.strip()

        # 🔹 Consulta tolerante a mayúsculas, pero sin eliminar '.html'
        LoduleID_query = """
            SELECT ModuleID, CompanyID, DivisionID, DepartamentID
            FROM Modules
            WHERE LOWER(RutaPython) = LOWER(?)
        """

        with get_connection() as conn:
            cursor = conn.cursor()
            cursor.execute(LoduleID_query, (ruta_limpia,))
            data = cursor.fetchone()

        # 🔹 Si no hay registro, lanzar error claro
        if not data:
            msg = f"Módulo no encontrado en BD para la ruta: {ruta_limpia}"
            logger.warning(msg)
            raise LookupError(msg)

        return data

    except LookupError:
        # Propagar LookupError para manejo explícito en UserAccess.py
        raise
    except Exception as e:
        logger.error(f"Error en get_ModuleID({ruta}): {e}")
        raise


def get_CompanyID_DivisionID_DepartamentID_Profile(UserID):
    try:
        # 1. Primero, verificar si el UserID existe en la tabla Users
        LoduleID_query = """
            SELECT CompanyID,DivisionID,DepartamentID FROM Profiles WHERE UserID = ?
        """
        with get_connection() as conn:
            cursor = conn.cursor()
            cursor.execute(LoduleID_query, (UserID,))
            data = cursor.fetchone()
            #ModuleID = data[0]  # Obtener el RequestTypeID
            return data
    except Exception as e:
        print(f"Error: {e}")
        raise

def get_RoleID(userid):
    try:
        # 1. Primero, verificar si el UserID existe en la tabla Users
        RoleID_query = """
            Select RoleID from UserRoles where UserID  = ?
        """
        with get_connection() as conn:
            cursor = conn.cursor()
            cursor.execute(RoleID_query, (userid,))
            data = cursor.fetchone()
            RoleID = data[0]  # Obtener el RequestTypeID
            print('------------------------>',RoleID)
            return  RoleID
    except Exception as e:
        print(f"Error: {e}")
        raise
    
def get_permiso(RoleID,ModuloID):
    try:
        # 1. Primero, verificar si el UserID existe en la tabla Users
        permiso_query = """
            Select count(*) from RoleModules where RoleID = ? AND ModuleID = ?
        """
        with get_connection() as conn:
            cursor = conn.cursor()
            cursor.execute(permiso_query, (RoleID,ModuloID,))
            data = cursor.fetchone()
            permiso = data[0]  # Obtener el RequestTypeID
            return permiso
    except Exception as e:
        print(f"Error: {e}")
        raise