# Archivo: loginSQL.py
# Ruta: src\Consultas_SQL\Security\loginSQL.py
# Lenguaje: Python con Flask
from flask import jsonify
from Consultas_SQL.conexion import get_connection

def consultar_users(email):
    try:
        query = """
                SELECT UserID, Email, PasswordHash, Status
                FROM Users
                WHERE Email = ?
            """
            
        with get_connection() as conn:
            cursor = conn.cursor()
            cursor.execute(query, [email])
            user_data = cursor.fetchone()
            
            if not user_data:
                print(f"Usuario no encontrado: {email}")
                return jsonify({
                    'success': False, 
                    'message': 'Credenciales incorrectas. Por favor, verifica tu correo y contraseña.'
                }), 401
                
            # Convertir el objeto Row a un diccionario
            user_dict = {
                'UserID': user_data[0],
                'Email': user_data[1],
                'PasswordHash': user_data[2],
                'Status': user_data[3]
            }
            return user_dict  
    except Exception as e:
        print(f"Error en consultar_users: {e}")
        return jsonify({
            'success': False, 
            'message': f'Error al consultar usuario: {str(e)}'
        }), 500

def Actualizar_ultimo_login(user_id):
    try:
        # Actualizar último login
        update_query = """
            UPDATE Users
            SET LastLogin = GETDATE()
            WHERE UserID = ?
        """
        with get_connection() as conn:
            cursor = conn.cursor()
            cursor.execute(update_query, [user_id])
            conn.commit()  # Asegurarse de hacer commit para guardar los cambios
            
            # Verificar si se actualizó alguna fila
            if cursor.rowcount == 0:
                print(f"No se actualizó ningún usuario con ID: {user_id}")
                return False
            return True
            
    except Exception as e:
        print(f"Error en Actualizar_ultimo_login: {e}")
        raise  # Propagar la excepción para manejarla en la función llamadora