# Archivo: DMCompanySQL.py
# Ruta: src\Consultas_SQL\SupYCtrol\DataMaster\DMCompanySQL.py
# Lenguaje: Python


from Consultas_SQL.conexion import get_connection

def get_companies():
    """Obtiene las compañías desde la base de datos."""
    query = """
    SELECT
        Company.CompanyID, 
        Company.Company, 
        Company.RFC, 
        Company.EntidadFederativa, 
        Company.MunicipioDelegacion, 
        Company.Colonia, 
        Company.Calle, 
        Company.Numero, 
        Company.CP, 
        Company.Telefono, 
        Company.Correo
    FROM
        dbo.Company
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()
        
        return [{"id": row[0], "company": row[1], "rfc": row[2], "Entidad": row[3], "Municipio": row[4], "Colonia": row[5], "Calle": row[6], "Numero": row[7], "CP": row[8], "Telefono": row[9], "Correo": row[10]} for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo compañías: {e}")
        return []
    finally:
        if conn:
            conn.close()
            
