# Archivo: DMDepartamentSQL.py
# Ruta: src\Consultas_SQL\SupYCtrol\DataMaster\DMDepartamentSQL.py
# Lenguaje: Python


from Consultas_SQL.conexion import get_connection

def get_departament():
    """Obtiene las compañías desde la base de datos."""
    query = """
    SELECT
        Departament.DepartamentID, 
        Departament.Departamento, 
        Departament.CompanyID,
        Departament.DivisionID
    FROM
        dbo.Departament
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()
        
        return [{"DepartamentID": row[0], "departament": row[1], "CompanyID": row[2], "DivisionID": row[3]} for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo compañías: {e}")
        return []
    finally:
        if conn:
            conn.close()
            
