# Archivo: DMDivisionSQL.py
# Ruta: src\Consultas_SQL\SupYCtrol\DataMaster\DMDivisionSQL.py
# Lenguaje: Python


from Consultas_SQL.conexion import get_connection

def get_division():
    """Obtiene las divisiones desde la base de datos."""
    query = """
    SELECT
        Division.DivisionID, 
        Division.Division, 
        Division.CompanyID
    FROM
        dbo.Division
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()
        
        return [{"DivisionID": row[0], "division": row[1], "CompanyID": row[2]} for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo divisiones: {e}")
        return []
    finally:
        if conn:
            conn.close()
            
